package com.bizunited.nebula.europa.sdk.vo;

import java.util.Map;

import com.bizunited.nebula.common.vo.TenantVo;

/**
 * 个性化数据视图展示信息
 * @author yinwenjie
 */
public class PersonalizationTemplateVo extends TenantVo {
  /**
   * 
   */
  private static final long serialVersionUID = -6257830294592481467L;
  /**
   * 个性化设定信息业务编号，和tenantCode + code全系统唯一
   */
  private String code;
  /**
   * 数据视图个性样式文件重命名后的文件名字
   */
  private String fileName;
  /**
   * 数据视图个性样式文件的存储路径，文件在本地的存储目录（相对位置，不包括文件名）<br>
   */
  private String relativeLocal;
  /**
   * 涉及到的欧罗巴数据视图基本信息的业务编号
   */
  private String europaInfoCode;
  /**
   * 参与本次匹配的各个业务模块维度的信息，key信息来源于PersonalizationTemplateStrategy接口的getName实现</br>
   * value信息为设定的维度值。整个信息在查询时，将按照优先级向后顺序进行排列</p>
   * 
   * 注意，在进行查询时，就算满足当前操作者的模板有多个，这里可能也只返回一个最匹配（优先级最高的）模板匹配信息
   */
  private Map<String , String> mathedMapping;
  
  public String getCode() {
    return code;
  }
  public void setCode(String code) {
    this.code = code;
  }
  public String getEuropaInfoCode() {
    return europaInfoCode;
  }
  public void setEuropaInfoCode(String europaInfoCode) {
    this.europaInfoCode = europaInfoCode;
  }
  public String getFileName() {
    return fileName;
  }
  public void setFileName(String fileName) {
    this.fileName = fileName;
  }
  public String getRelativeLocal() {
    return relativeLocal;
  }
  public void setRelativeLocal(String relativeLocal) {
    this.relativeLocal = relativeLocal;
  }
  public Map<String, String> getMathedMapping() {
    return mathedMapping;
  }
  public void setMathedMapping(Map<String, String> mathedMapping) {
    this.mathedMapping = mathedMapping;
  }
}
