package com.bizunited.nebula.event.sdk.service;

import java.util.Map;
import java.util.Set;

/**
 * jvm内事件容器管理器
 * @author hefan
 */
public interface NebulaEventContainerManagement {

  /**
   * 根据类名，获取事件实现
   * @param className
   * @return
   */
  Set<NebulaEvent> getEventImplByClassName(String className);

  /**
   * 把所有事件实现放到了容器里
   */
  void putEventImplByClassName();

  /**
   * 返回JVM的事件容器
   * @return
   */
  Map<String, Set<NebulaEvent>> getEventContainer();

}
