package com.bizunited.nebula.event.sdk.service;

import com.bizunited.nebula.event.sdk.model.EventProvider;

import java.util.List;
import java.util.function.UnaryOperator;

/**
 * 事件编排器
 *
 * @author hefan
 */
public interface NebulaNetEventArrangement {

  /**
   * 编排事件提供者的信息，形成一个调用链
   * 使用默认的网络事件调用侧（消费侧）
   * 使用默认的消费者排列规则
   *
   * @param eventProviders
   * @return
   */
  List<NebulaNetEventConsumer> arrangeEvent(List<EventProvider> eventProviders);

  /**
   * 编排事件提供者的信息，形成一个调用链
   * 必须指定网络事件调用侧（消费侧）
   * 使用默认的消费者排列规则
   *
   * @param eventProviders
   * @param clazz
   * @return
   */
  List<NebulaNetEventConsumer> arrangeEvent(List<EventProvider> eventProviders, Class<? extends NebulaNetEventConsumer> clazz);

  /**
   * 编排事件提供者的信息，形成一个调用链
   * 使用默认的网络事件调用侧（消费侧）
   * 必须指定消费者排列规则
   *
   * @param eventProviders
   * @param unaryOperator
   * @return
   */
  List<NebulaNetEventConsumer> arrangeEvent(List<EventProvider> eventProviders, UnaryOperator<List<EventProvider>> unaryOperator);

  /**
   * 编排事件提供者的信息，形成一个调用链
   * 必须指定网络事件调用侧（消费侧）
   * 必须指定消费者排列规则
   *
   * @param eventProviders
   * @param unaryOperator
   * @param clazz
   * @return
   */
  List<NebulaNetEventConsumer> arrangeEvent(List<EventProvider> eventProviders, UnaryOperator<List<EventProvider>> unaryOperator, Class<? extends NebulaNetEventConsumer> clazz);

}
