package com.bizunited.nebula.event.sdk.service;

import com.bizunited.nebula.event.sdk.function.SerializableBiConsumer;
import com.bizunited.nebula.event.sdk.model.EventResponse;

import java.util.List;

/**
 * @author hefan
 */
public interface NebulaNetEventClient {

  /**
   * 发布事件
   * 使用默认的网络事件消费者链
   * 使用默认的网络事件调用侧（消费侧）
   * 使用默认的消费者排列规则
   *
   * @param nebulaEventDto
   * @param event
   * @param func
   */
  void publish(NebulaEventDto nebulaEventDto, Class<? extends NebulaEvent> event, SerializableBiConsumer<? extends NebulaEvent,? extends NebulaEventDto> func);

  /**
   * 发布事件
   * 必须指定使用的 网络事件链管理器
   * 使用默认的网络事件调用侧（消费侧）
   * 使用默认的消费者排列规则
   *
   * @param nebulaEventDto
   * @param event
   * @param func
   * @param chainClass
   */
  public void publish(NebulaEventDto nebulaEventDto, Class<? extends NebulaEvent> event, SerializableBiConsumer<? extends NebulaEvent,? extends NebulaEventDto> func, Class<? extends NebulaNetEventConsumerChain> chainClass);


  default void publishToService(NebulaEventDto nebulaEventDto, Class<? extends NebulaEvent> event, SerializableBiConsumer<? extends NebulaEvent,? extends NebulaEventDto> func) {
    throw new IllegalArgumentException("not support publishToService method!!!");
  }


  /**
   * 发布事件
   * 必须指定 编排过的网络事件调用侧（消费侧）
   * 必须指定使用的 网络事件链管理器
   *
   * @param nebulaEventDto
   * @param nebulaNetEventConsumers
   * @param chainClass
   */
  public void publish(NebulaEventDto nebulaEventDto, List<NebulaNetEventConsumer> nebulaNetEventConsumers, Class<? extends NebulaNetEventConsumerChain> chainClass);

  /**
   * 发布事件
   * 必须指定 编排过的网络事件调用侧（消费侧）
   * 使用默认的网络事件消费者链
   *
   * @param nebulaEventDto
   * @param nebulaNetEventConsumers
   */
  public void publish(NebulaEventDto nebulaEventDto, List<NebulaNetEventConsumer> nebulaNetEventConsumers);

  /**
   * 直连发布
   * -- 就跟直接使用http访问远端接口，一个意思。
   * -- 不要用这个方法调用同一个jvm内的上层事件
   */
  public EventResponse directPublish(NebulaEventDto nebulaEventDto, Class<? extends NebulaEvent> event, SerializableBiConsumer<? extends NebulaEvent,? extends NebulaEventDto> func);

  /**
   * 发布到应用程序
   * -- appName为空字符，调用所有应用
   * -- appName指定，调用指定的应用
   * -- subClassName 为空字符，调用所有实现
   * -- subClassName指定，调用指定的实现
   * -- 返回结果在 EventResponse.eventResponses里面。是每个实现的返回结果的jsonString
   *
   * @param nebulaEventDto  星云事件dto
   * @param event           事件
   * @param func            函数
   * @return {@link EventResponse}
   */
  EventResponse publishToApplication(NebulaEventDto nebulaEventDto, Class<? extends NebulaEvent> event, SerializableBiConsumer<? extends NebulaEvent,? extends NebulaEventDto> func);

}
