package com.bizunited.nebula.event.sdk.service;

import com.bizunited.nebula.event.sdk.model.EventProvider;

import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * 网络事件容器控制器
 *  跟JVM事件容器不同之处，就是我有别个JVM的服务地址
 * @author hefan
 */
public interface NebulaNetEventContainerManagement {

  /**
   * 从网络事件驱动容器内，查询 event 的所有 服务URI(包装pojo)
   * @param event
   * @param methodName
   * @return
   */
  @Deprecated
  List<EventProvider> getEventProvider(Class<? extends NebulaEvent> event, String methodName);

  /**
   * 移除本服务的事件提供者
   */
  void removeEventProviderIgnore(Map<String, Set<NebulaEvent>> eventContainer);

  /**
   * 把JVM容器里的事件实现都存到配置中心去
   *
   * @param eventContainer
   */
  void putEventProvider(Map<String, Set<NebulaEvent>> eventContainer);

  /**
   * 从网络事件驱动容器内，查询 event 的所有 服务URI(包装pojo)
   * @param event
   * @return
   */
  List<EventProvider> getEventProvider(Class<? extends NebulaEvent> event);
}
