package com.bizunited.nebula.event.sdk.dto;

import com.bizunited.nebula.event.sdk.service.NebulaEventDto;
import lombok.Data;

/**
 * 为了简化事件驱动的实现
 *
 * @author hefan
 */
@Data
public class EventDto {

  /**
   * 事件的类
   */
  String name;

  /**
   * 事件的名称
   */
  String methodName;

  /**
   * 传输的入参信息
   */
  String jsonData;

  /**
   * 使用事务
   */
  Boolean isTransaction = false;

  /**
   * 是来关闭事务的
   */
  Boolean isEndTransaction = false;

  /**
   * 事件的 dto Class
   */
  Class<? extends NebulaEventDto> dtoClass;

}
