package com.bizunited.nebula.event.sdk.model;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.springframework.stereotype.Component;

/**
 * 事件用的nacos配置
 *
 * @author hefan
 * @date 2023/02/16
 */
@Component
@Data
@NoArgsConstructor
@AllArgsConstructor
public class EventNacosProperties {

  /**
   * 服务器地址：nacos的 ip:port
   */
  private String serverAddr;

  /**
   * nacos的名称空间ID
   */
  private String namespace;

  /**
   * 此处对应：微服务名称
   */
  private String serviceName;

  /**
   * 此处对应：请求协议
   */
  private String protocol;

  /**
   * nacos访问的超时时间（毫秒）
   */
  private long timeoutMs = 5000L;

}
