package com.bizunited.nebula.event.sdk.model;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

/**
 * 事件属性
 *
 * @author hefan
 * @date 2023/02/16
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@Component
@ConfigurationProperties(prefix = "event")
public class EventProperties {

  /**
   * 事件引擎的实现方案：nacos、redis
   */
  private String scheme;

  /**
   * 有效时间间隔。单位：分钟
   */
  private Integer effectiveInterval = 4;

  /**
   * nacos配置信息
   */
  private EventNacosProperties nacos;

  /**
   * redis配置信息
   */
  private EventRedisProperties redis = new EventRedisProperties();

  /**
   * 事务ID碰撞时提交
   */
  private Boolean committedWhenTransactionIDCollides = true;


}
