package com.bizunited.nebula.event.sdk.model;

import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.Date;

/**
 *
 * @author hefan
 */
@Data
@EqualsAndHashCode(callSuper = false)
public class EventProvider {

  /**
   * 服务名 或者 ip + 端口
   */
  private String serviceName;

  /**
   * 应用上下文路径
   */
  private String contextPath;

  /**
   * 应用端口
   */
  private String port;

  /**
   * 类上url
   */
  private String classUrl;

  /**
   * 方法url
   */
  private String methodUrl;

  /**
   * 事件方法
   */
  private String methodName;

  /**
   * 前置标识
   */
  private String preFlag;

  /**
   * 顺序
   */
  private String order;

  /**
   * 协议
   */
  private String protocol;

  /**
   * 请求方式
   */
  private String requestMethod;

  /**
   * nacos的分组，同时也是事件接口的方法名
   */
  private String group;

  /**
   * nacos的dataId，同时也是事件接口的全限定名
   */
  private String dataId;

  /**
   * 事件数据的刷新时间
   */
  @EqualsAndHashCode.Exclude
  private Date resetTime;

}
