package com.bizunited.nebula.event.sdk.service;

import com.bizunited.nebula.event.sdk.model.EventProvider;

import java.util.List;
import java.util.function.UnaryOperator;

/**
 * 事件排列器
 *
 * @author hefan
 */
public interface EventArrangement {

  /**
   * 编排事件提供者的信息，形成一个调用链
   * 使用默认的网络事件调用侧（消费侧）
   * 使用默认的消费者排列规则
   *
   * @param eventProviders
   * @return
   */
  List<EventConsumer> arrangeEvent(List<EventProvider> eventProviders);

  /**
   * 编排事件提供者的信息，形成一个调用链
   * 必须指定网络事件调用侧（消费侧）
   * 使用默认的消费者排列规则
   *
   * @param eventProviders
   * @param clazz
   * @return
   */
  List<EventConsumer> arrangeEvent(List<EventProvider> eventProviders, Class<? extends EventConsumer> clazz);

  /**
   * 编排事件提供者的信息，形成一个调用链
   * 使用默认的网络事件调用侧（消费侧）
   * 必须指定消费者排列规则
   *
   * @param eventProviders
   * @param unaryOperator
   * @return
   */
  List<EventConsumer> arrangeEvent(List<EventProvider> eventProviders, UnaryOperator<List<EventProvider>> unaryOperator);

  /**
   * 编排事件提供者的信息，形成一个调用链
   * 必须指定网络事件调用侧（消费侧）
   * 必须指定消费者排列规则
   *
   * @param eventProviders
   * @param unaryOperator
   * @param clazz
   * @return
   */
  List<EventConsumer> arrangeEvent(List<EventProvider> eventProviders, UnaryOperator<List<EventProvider>> unaryOperator, Class<? extends EventConsumer> clazz);

}
