package com.bizunited.nebula.event.sdk.service;

import com.bizunited.nebula.event.sdk.function.SerializableBiConsumer;
import com.bizunited.nebula.event.sdk.model.EventResponse;

/**
 * 事件客户端
 * - 不管是jvm内部的事件，还是外部的网络事件，都由client负责发起
 * @author hefan
 */
public interface EventClient {

  /**
   * 发布事件
   * 使用默认的网络事件消费者链
   * 使用默认的网络事件调用侧（消费侧）
   * 使用默认的消费者排列规则
   *
   * @param nebulaEventDto
   * @param event
   * @param func
   */
  void publish(NebulaEventDto nebulaEventDto, Class<? extends NebulaEvent> event, SerializableBiConsumer<? extends NebulaEvent,? extends NebulaEventDto> func);

  /**
   * 直连发布
   * -- 就跟直接使用http访问远端接口，一个意思。
   * -- 不要用这个方法调用同一个jvm内的上层事件
   * -- 只有一个实现的时候，EventResponse就是返回模型
   * -- 有多个实现的时候，返回结果在 EventResponse.eventResponses里面。是每个实现的返回结果的jsonString
   *
   * @param nebulaEventDto 星云事件dto
   * @param event          事件
   * @param func           函数
   * @return {@link EventResponse}
   */
  @Deprecated
  public EventResponse directPublish(NebulaEventDto nebulaEventDto, Class<? extends NebulaEvent> event, SerializableBiConsumer<? extends NebulaEvent,? extends NebulaEventDto> func);

  /**
   * 发布到应用程序
   * -- appName为空字符，调用所有应用
   * -- appName指定，调用指定的应用
   * -- subClassName 为空字符，调用所有实现
   * -- subClassName指定，调用指定的实现
   * -- 返回结果在 EventResponse.eventResponses里面。是每个实现的返回结果的jsonString
   *
   * @param nebulaEventDto  星云事件dto
   * @param event           事件
   * @param func            函数
   * @return {@link EventResponse}
   */
  EventResponse publishToApplication(NebulaEventDto nebulaEventDto,
                                     Class<? extends NebulaEvent> event,
                                     SerializableBiConsumer<? extends NebulaEvent,? extends NebulaEventDto> func);


  /**
   * 发布在事务
   * 比 publishToApplication方法多了事务
   *
   * @param nebulaEventDto 星云事件dto
   * @param event          事件
   * @param func           函数
   * @return {@link EventResponse}
   */
  EventResponse publishOnTransaction(NebulaEventDto nebulaEventDto,
                                     Class<? extends NebulaEvent> event,
                                     SerializableBiConsumer<? extends NebulaEvent,? extends NebulaEventDto> func);





}
