package com.bizunited.nebula.event.sdk.service;

import com.bizunited.nebula.event.sdk.model.EventProvider;
import com.fasterxml.jackson.core.type.TypeReference;

import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * 网络事件容器控制器
 *  跟LocalEventContainerManagement不同之处，就是EventContainerManagement有其他JVM的服务地址
 * @author hefan
 */
public interface EventContainerManagement {

  /**
   * 类型
   */
  TypeReference<List<EventProvider>> TYPE = new TypeReference<List<EventProvider>>() {};

  /**
   * 移除本服务的事件提供者
   *
   * @param eventContainer 事件容器
   */
  void removeEventProvider(Map<String, Set<NebulaEvent>> eventContainer);

  /**
   * 把JVM容器里的事件实现都存到配置中心去
   *
   * @param eventContainer
   */
  void putEventProvider(Map<String, Set<NebulaEvent>> eventContainer);

  /**
   * 从网络事件驱动容器内，查询 event 的所有 服务URI(包装pojo)
   * @param event
   * @return
   */
  List<EventProvider> getEventProvider(Class<? extends NebulaEvent> event);
}
