package com.bizunited.nebula.event.sdk.service;

import com.bizunited.nebula.event.sdk.model.EventProvider;

import java.util.List;

/**
 * 事件数据持久性处理器
 *
 * @author hefan
 * @date 2023/02/20
 */
public interface EventDataPersistenceProcessor {

  /**
   * 保存事件提供程序
   *
   * @param dataId         数据标识
   * @param group          集团
   * @param eventProviders 事件服务提供商
   */
  void saveEventProvider(String dataId, String group, List<EventProvider> eventProviders);

  /**
   * 删除自己
   *
   * @param dataId         数据标识
   * @param group          集团
   * @param eventProviders 事件服务提供商
   */
  void removeOneself(String dataId, String group, List<EventProvider> eventProviders);

  /**
   * 发现通过数据id
   *
   * @param dataId 数据标识
   * @return {@link List}<{@link EventProvider}>
   */
  List<EventProvider> findByDataId(String dataId, String group);
}
