package com.bizunited.nebula.event.sdk.service;

import com.bizunited.nebula.event.sdk.model.EventResponse;

/**
 * 处理事件的服务
 * @author hefan
 */
public interface NebulaEventServer {

  /**
   * 发送的事件，到这里处理。
   * @param simpleName
   * @param methodName
   * @param nebulaEventDto
   */
  EventResponse execute(String simpleName, String methodName, NebulaEventDto nebulaEventDto);


  /**
   * 执行与事务开始
   *
   * @param simpleName     简单名称
   * @param methodName     方法名称
   * @param nebulaEventDto 星云事件dto
   * @return {@link EventResponse}
   */
  EventResponse executeWithTransactionBegin(String simpleName, String methodName, NebulaEventDto nebulaEventDto);

  /**
   * 执行事务结束
   *
   * @param simpleName     简单名称
   * @param methodName     方法名称
   * @param nebulaEventDto 星云事件dto
   * @return {@link EventResponse}
   */
  void executeWithTransactionEnd(String simpleName, String methodName, NebulaEventDto nebulaEventDto);


}
