package com.bizunited.nebula.gateway.sdk.common;

/**
 * 网关应用常量
 *
 * @author Keller
 */
public class Constants {

  /**
   * Content-Type Header
   */
  public static final String HEADER_CONTENT_TYPE = "Content-Type";

  /**
   * JSON Content-Type
   */
  public static final String CONTENT_TYPE_JSON = "application/json; charset=UTF-8";

  /**
   * Header key to transfer traceId
   */
  public static final String HEADER_TRACE_ID = "X-TRACE-ID";

  /**
   * 服务器版本号
   */
  public static final String VERSION_NAME = "Version";

  /**
   * 服务器名
   */
  public static final String SERVER_NAME = "Server";

  /**
   * 网关所附加的head信息，在head区域的属性名
   */
  public static final String TENANT_HEAD_NAME = "tenant";

  /**
   * 网关所附加的head信息，描述了本次请求的源头（源头可能是一个外部的二级域名，也可能是一个内部的二级域名）
   */
  public static final String DOMAIN_SOURCE_NAME = "domain_source";
  
  public static final String JWT = "jwt";
}
