package com.bizunited.nebula.gateway.sdk.event;

import org.springframework.web.server.ServerWebExchange;

/**
 * 这个事件在http请求在gateway网关中被代理时，触发
 * @author yinwenjie
 *
 */
public interface HttpProxyListener {
  /**
   * 当网关接收到某个HTTP代理请求时（例如内部系统通过网关进行外部接口的代理转发时），该方法被触发
   */
  public void onProxyRequest(ServerWebExchange exchange , byte[] requestBodyContent);
  
  /**
   * 当网关接收到某个http代理请求后的响应信息时，该方法被触发
   */
  public void onProxyResponse(ServerWebExchange exchange , byte[] responseBodyContent);
}
