package com.bizunited.nebula.gateway.sdk.service;

import com.bizunited.nebula.gateway.sdk.vo.GatewayDomainVo;

/**
 * 网关信息缓存服务，这个服务将当前配置的为指定桶资源服务的所有网关路由配置，在内存中进行存储、读取、刷新操作
 * @author yinwenjie
 *
 */
public interface GatewayDomainVoService {

  /**
   * 由于路由信息刷新时，该网管不能继续工作，且刷新路由本来就是一个低频次操作
   * 所以使用Object Monitor保证同步效应
   */
  public static final Object LOCK_OBJECT = new Object();

  /**
   * 该方法用于返回当前网关是否正在刷新
   * @param bucketCode 指定的资源桶在整个架构中的唯一业务编号
   */
  public boolean isRefreshing();

  /**
   * 当网关节点收到MQ事件（资源桶中任意租户的域名信息发生变化的事件）通知以后，可以使用该方法更新为这个资源桶服务的，缓存在网关节点内存中的所有路由信息
   * @param bucketCode 指定的资源桶在整个架构中的唯一业务编号
   */
  public void refresh(String bucketCode);

  /**
   * 类似于#GatewayDomainVoService.refresh(String bucketCode)方法，不过其刷新场景是，无论什么情况都进行本gateway进程的刷新
   */
  public void refresh();

  /**
   * 根据一个指定的域名，在外部路由表中查询路由节点信息
   * 注意，如果路由表正在刷新，则需要刷新后再进行查询
   * @param domain
   * @return
   */
  public GatewayDomainVo findByExternalDomain(String domain);

  /**
   * 根据一个指定的域名，在内部路由表中查询路由节点信息
   * 注意，如果路由表正在刷新，则需要刷新后再进行查询
   * @param domain
   * @return
   */
  public GatewayDomainVo findByInternalDomain(String domain);
}
