package com.bizunited.nebula.gateway.sdk.service;

import com.bizunited.nebula.gateway.sdk.vo.GatewayDomainVo;
import org.springframework.web.server.ServerWebExchange;

/**
 * groovy执行结果缓存，groovy脚本并不是每一次都要执行，毕竟其性能不太好，</br>
 * 所以执行结果需要按照入参情况进行缓存，缓存信息需要使用软连接进行记录，这样以便于清理
 * @author yinwenjie
 */
public interface GroovyInvokeCachedService {
  /**
   * 清理缓存信息
   */
  public void clear();

  /**
   * 正式进行groovy脚本的调用
   * @param exchange 当次调用的http通道信息
   * @param gatewayDomain 已经确定的指定桶资源中的各信息描述
   * @return
   */
  public String invoke(ServerWebExchange exchange , GatewayDomainVo gatewayDomain);
}

