package com.bizunited.nebula.gateway.sdk.service;

import java.util.concurrent.Semaphore;

/**
 * 和当前网关进行租户限流有关的服务方法在此定义
 * @author yinwenjie
 */
public interface TenantInfoFlowService {
  /**
   * 类似于#TenantInfoVoService.refresh(String bucketCode)方法，不过其刷新场景是，无论什么情况都进行本gateway进程的刷新
   */
  public void refresh();
  /**
   * 该方法用于返回当前网关是否正在刷新
   * @param bucketCode 指定的资源桶在整个架构中的唯一业务编号
   */
  public boolean isRefreshing();

  /**
   * 注意，如果当前限流服务正在刷新，则调用该方法的线程将被阻塞，直到刷新操作完成
   * @param tenantCode 指定的租户code，业务编号
   * @param appType 指定的应用程序类型
   * @return
   */
  public Semaphore findByTenantCode(String tenantCode , Integer appType);

  /**
   * 返回当前gateway所服务的、状态正常的租户的总的权重值(以资源桶为单位)
   * @return
   */
  public Integer weightCount(String bucketCode);

  /**
   * 返回当前gateway所服务的指定租户的权重值（最大为5）
   * @param tenantCode 指定的租户code，业务编号
   * @param appType 指定的应用程序类型
   * @return
   */
  public Integer weightCount(String tenantCode, Integer appType);
}
