package com.bizunited.nebula.gateway.sdk.service;

import java.util.List;

import com.bizunited.nebula.gateway.sdk.vo.TenantInfoVo;

/**
 * 租户-域信息，视图服务
 * @author yinwenjie
 */
public interface TenantInfoVoService {
  /**
   * 由于租户信息刷新时，该网管不能继续工作，且刷新租户本来就是一个低频次操作
   * 所以使用Object Monitor保证同步效应
   */
  public static final Object LOCK_OBJECT = new Object();
  /**
   * 当指定的租户发生变化时，重新刷新和这个租户相关的域路由信息
   * @param tenantCode
   */
  public void refresh(String tenantCode);
  /**
   * 类似于#TenantInfoVoService.refresh(String bucketCode)方法，不过其刷新场景是，无论什么情况都进行本gateway进程的刷新
   */
  public void refresh();
  /**
   * 该方法用于返回当前网关是否正在刷新
   * @param bucketCode 指定的资源桶在整个架构中的唯一业务编号
   */
  public boolean isRefreshing();
  /**
   * 按照指定的租户业务编码信息，查询这个租户驻留在内存中的关联的所有域信息
   * @param tenantCode
   * @return 如果没有查询到，则返回null
   */
  public TenantInfoVo findByTenantCode(String tenantCode);
  /**
   * 根据租户状态查找
   * @param status 1：启用；0：禁用
   * @return
   */
  public List<TenantInfoVo> findByState(Integer status);
  
  /**
   * 设定一个租户的可用状态为“不可用”，以便在网关层可以阻止不可用的租户请求
   * @param tenantCode 指定的租户业务编号
   */
  public void setDisable(String tenantCode);

  /**
   * 设定一个租户的可用状态为“可用”
   * @param tenantCode 指定的租户业务编号
   */
  public void setEnable(String tenantCode);

  /**
   * 检查一个租户的可用状态
   * @param tenantCode 指定的租户业务编号
   * @return 如果可用则返回true；其它情况返回false
   */
  public Boolean validateStatus(String tenantCode);
}
