package com.bizunited.nebula.gateway.sdk.strategy;

import com.bizunited.nebula.gateway.sdk.vo.GatewayDomainVo;
import org.springframework.web.server.ServerWebExchange;

/**
 * 路由分组策略是在网关已经明确了当前URL请求应该分配给哪个资源桶处理后，在未明确应该分配给哪组负载均衡组时，</br>
 * 通过实现该策略，来明确应该由哪组负载均衡组处理该请求。</p>
 *
 * 这样的策略确认场景适合用于诸如A/B测试、蓝绿发布这样的场景
 * @author yinwenjie
 */
public interface DomainRouteGroupStrategy {

  /**
   * 默认的负责均衡路由分组名
   */
  public static final String DEFAULT_GROUP_CODE = "default";

  /**
   * 本策略实现的优先级，数字越小优先级越高
   * @return
   */
  public int sort();
  /**
   * 实现该方法，以便告知LoadBalancerFilter这个策略是否应该是自己处理
   * @param exchange 当前请求在响应式编程中的exchange通道对象
   * @param gatewayDomain 当前已经确认的路由信息，请注意其中携带的gatewayRouteNodes信息，注意不要直接修改
   * @return  返回false，表示本次URL请求不由本策略进行支持；返回true，表示本次URL请求将由本策略进行负载分组支持
   */
  public boolean strategy(ServerWebExchange exchange , GatewayDomainVo gatewayDomain);
  /**
   * 当strategy返回true的情况下，该策略的route方法将被调用
   * @return 该方法将返回一个字符串，这个字符串将指向当前资源桶下的一个已经设置的路由分组标识。<br>
   * 如果返回null（或空字符串），或者返回的路由分组标识并没有设置，则会使用默认的分组
   */
  public String route(ServerWebExchange exchange , GatewayDomainVo gatewayDomain);
}

