package com.bizunited.nebula.gateway.sdk.strategy;

import org.springframework.http.HttpHeaders;
import org.springframework.http.server.reactive.ServerHttpRequest;

/**
 * Groovy脚本路由策略，实现该接口的groovy脚本一旦通过route方法返回了非空字符串，</br>
 * 那么网关的负载均衡路由将按照这个字符串描述的负载分组进行请求的路由发放。
 * @author yinwenjie
 *
 */
public interface ScriptRouteStrategy {
  /**
   * 本次URL请求信息的request对象和header对象将被传入。
   * @return 如果该路由不匹配，则返回null或者空字符窜
   */
  public String route(ServerHttpRequest request , HttpHeaders headers);
}
