package com.bizunited.nebula.gateway.sdk.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;
import java.util.Map;

/**
 * 指定网关下的域信息
 * @author yinwenjie
 */

@ApiModel("指定网关下的域信息")
@Data
public class GatewayDomainVo {

  /** 对应的租户业务编码 */
  @ApiModelProperty("对应的租户业务编码")
  private String tenantCode;

  /** 对应的租户业务名 */
  private String tenantName;

  /** 完整的域名信息 */
  @ApiModelProperty("完整的域名信息")
  private String domain;

  /** 此域名路由的业务系统类型：厂商管理PC系统1、经销商管理PC系统2、微信客户端小程序系统3、微信业务员小程序系统4、原生APP系统5 */
  @ApiModelProperty("此域名路由的业务系统类型：厂商管理PC系统1、经销商管理PC系统2、微信客户端小程序系统3、微信业务员小程序系统4、原生APP系统5")
  private Integer appType;

  /** 外部域路由：外部域路由到Nodejs集群；内部域路由到Spring boot集群 */
  @ApiModelProperty("外部域路由：外部域路由到Nodejs集群；内部域路由到Spring boot集群")
  private Boolean external = true;

  /** 为每一个域配置的详细路由表 */
  // 按照设置的路由分组进行路由表记录，key：路由分组（默认为default）
  private Map<String , List<GatewayRouteNodeVo>> gatewayRouteNodes;
}