package com.bizunited.nebula.gateway.sdk.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 域路由表
 * @author yinwenjie
 */
@ApiModel(value = "GatewayRouteNodeVo", description = "资源桶中的nodejs信息")
@Data
public class GatewayRouteNodeVo {

  /** 服务node节点的实际IP地址（内网IP） */
  @ApiModelProperty("服务node节点的实际IP地址（内网IP）")
  private String ip;

  /** 服务node节点的实际访问端口信息 */
  @ApiModelProperty("服务node节点的实际访问端口信息")
  private Integer port;

  /** 支持的协议，只可能是http或者https */
  private String agreement;
  
  /** 网关分组，没有填写就是默认分组 */
  @ApiModelProperty("网关分组，没有填写就是默认分组")
  private String groupCode;
}
