package com.bizunited.nebula.gateway.sdk.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

@ApiModel("租户下的域信息")
@Data
public class TenantDomainVo {

  /** 完整的域名信息 */
  @ApiModelProperty("完整的域名信息")
  private String domain;

  /** 此域名路由的业务系统类型：厂商管理PC系统1、经销商管理PC系统2、微信客户端小程序系统3、微信业务员小程序系统4、原生APP系统5 */
  @ApiModelProperty("此域名路由的业务系统类型：厂商管理PC系统1、经销商管理PC系统2、微信客户端小程序系统3、微信业务员小程序系统4、原生APP系统5")
  private Integer appType;

  /** 外部域路由：外部域路由到Nodejs集群；内部域路由到Spring boot集群 */
  @ApiModelProperty("外部域路由：外部域路由到Nodejs集群；内部域路由到Spring boot集群")
  private Boolean external = true;
}