package com.bizunited.nebula.gateway.sdk.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import lombok.Getter;
import lombok.Setter;

import java.util.List;

/**
 * 指定租户以及租户下的域信息
 * @author yinwenjie
 */
@ApiModel("指定租户以及租户下的域信息")
@Getter
@Setter
public class TenantInfoVo {

  /** 对应的租户业务编码 */
  @ApiModelProperty("对应的租户业务编码")
  private String tenantCode;

  /** 对应的租户业务名 */
  private String tenantName;

  /** 为当前客户所服务的网关端口 */
  private Integer gatewayPort;
  
  /** 网关内部系统互相调用时所使用的访问协议，一般为http协议 */
  private String scheme;
  
  /** 租户下的域名信息  */
  List<TenantDomainVo> TenantDomains;
}

