package com.bizunited.nebula.icon.local.controller;

import com.bizunited.nebula.common.controller.BaseController;
import com.bizunited.nebula.common.controller.model.ResponseModel;
import com.bizunited.nebula.icon.local.service.IconService;
import com.bizunited.nebula.icon.sdk.dto.IconDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * 图标管理
 *
 * @author hefan
 */
@Api(tags = "图标管理：Icon：图标管理")
@RestController
@RequestMapping("/v1/icon/icon")
public class IconController extends BaseController {

  @Autowired
  private IconService iconService;

  private static final Logger log = LoggerFactory.getLogger(IconController.class);
  
  /**
   * hefan:
   * 新增图标
   *
   * @param iconDto
   * @return
   */
  @ApiOperation(value = "新增")
  @PostMapping("/createByIconDto")
  public ResponseModel createByIconDto(@RequestBody IconDto iconDto) {
    try {
      this.iconService.createByIconDto(iconDto);
      return this.buildHttpResult();
    } catch (Exception e) {
      log.error(e.getMessage(), e); 
      return this.buildHttpResultForException(e);
    }

  }

  /**
   * hefan: 修改图标
   *
   * @param iconDto
   * @return
   */
  @ApiOperation(value = "更新")
  @PatchMapping("/updateByIconDto")
  public ResponseModel updateByIconDto(@RequestBody IconDto iconDto) {
    try {
      this.iconService.updateByIconDto(iconDto);
      return this.buildHttpResult("修改成功");
    } catch (Exception e) {
      log.error(e.getMessage(), e);
      return this.buildHttpResultForException(e);
    }
  }

  /**
   * hefan: 根据id集合删除
   *
   * @param ids
   * @return
   */
  @ApiImplicitParams({
      @ApiImplicitParam(name = "ids", value = "id集合", required = true, paramType = "body")
  })
  @ApiOperation(value = "删除")
  @DeleteMapping("/deleteByIdIn")
  public ResponseModel deleteByIdIn(@RequestParam List<String> ids) {
    try {
      this.iconService.deleteByIdIn(ids);
      return this.buildHttpResult("删除成功");
    } catch (Exception e) {
      log.error(e.getMessage(), e);
      return this.buildHttpResultForException(e);
    }
  }
}
