package com.bizunited.nebula.icon.local.controller;

import com.bizunited.nebula.common.controller.BaseController;
import com.bizunited.nebula.common.controller.model.ResponseModel;
import com.bizunited.nebula.icon.sdk.dto.IconPaginationDto;
import com.bizunited.nebula.icon.sdk.service.IconVoService;
import com.bizunited.nebula.icon.sdk.vo.IconVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/**
 * 图标管理
 *
 * @author hefan
 */
@Api(tags = "图标管理：IconVo：图标管理")
@RestController
@RequestMapping("/v1/icon/icon")
public class IconVoController extends BaseController {

  @Autowired
  private IconVoService iconVoService;

  private static final Logger log = LoggerFactory.getLogger(IconController.class);
  
  /**
   * hefan：分页-动态查询 icon
   * 列表
   */
  @ApiOperation(value = "多条件分页查询", notes = "分页参数为page和size，page从0开始，size默认50;" +
      "可传的参数：FunctionSubPaginationDto")
  @GetMapping("/findByConditions")
  public ResponseModel findByConditions(@PageableDefault(50) Pageable pageable,
                                        @ApiParam(name = "iconPaginationDto", value = "分页Dto") IconPaginationDto iconPaginationDto) {
    try {
      Page<IconVo> result = this.iconVoService.findByCondition(pageable, iconPaginationDto);
      return this.buildHttpResultW(result);
    } catch (Exception e) {
      log.error(e.getMessage(), e);
      return this.buildHttpResultForException(e);
    }
  }


  /**
   * hefan:
   * 根据 【id】 或者【iconCode】 查询一条信息
   *
   * @param id
   * @param iconCode
   * @return
   */
  @ApiImplicitParams({
      @ApiImplicitParam(name = "id", value = "id", required = false, paramType = "query"),
      @ApiImplicitParam(name = "iconCode", value = "图标编码", required = false, paramType = "query"),
  })
  @ApiOperation(value = "根据 【id】 或者【iconCode】 查询一条信息")
  @GetMapping("/findByIdOrIconCode")
  public ResponseModel findByIdOrIconCode(@RequestParam(value = "id", required = false) String id,
                                          @RequestParam(value = "iconCode", required = false) String iconCode) {
    try {
      IconVo respVo = this.iconVoService.findByIdOrIconCode(id, iconCode);
      return this.buildHttpResultW(respVo);
    } catch (Exception e) {
      log.error(e.getMessage(), e);
      return this.buildHttpResultForException(e);
    }
  }


}
