package com.bizunited.nebula.icon.local.deprecated.controller;

import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.icon.local.controller.IconController;
import com.bizunited.nebula.icon.local.controller.IconVoController;
import com.bizunited.nebula.icon.sdk.deprecated.dto.MdmIconReqVo;
import com.bizunited.nebula.icon.sdk.dto.IconDto;
import com.bizunited.nebula.icon.sdk.dto.IconPaginationDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;

/**
 * @author zxw
 */
@Deprecated
@RestController
@RequestMapping("/mdmicon")
@Api(tags = "图标管理")
public class MdmIconController {

  @Autowired
  private IconVoController iconVoController;
  @Autowired
  private NebulaToolkitService nebulaToolkitService;

  /**
   * hefan:
   * 分页 动态条件查询
   *
   * @param mdmIconReqVo
   * @return
   */
  @ApiOperation(value = "分页查询")
  @PostMapping("/list")
  public void list(@RequestBody MdmIconReqVo mdmIconReqVo) {
    PageRequest of = PageRequest.of(1,10);
    IconPaginationDto functionSubPaginationDto = this.nebulaToolkitService.copyObjectByBlankList(mdmIconReqVo, IconPaginationDto.class, HashSet.class, LinkedList.class);
    iconVoController.findByConditions(of, functionSubPaginationDto);
  }

  @Autowired
  private IconController iconController;

  /**
   * hefan:
   * 新增图标
   *
   * @param mdmIconReqVo
   * @return
   */
  @ApiOperation(value = "新增")
  @PostMapping("/save")
  public void save(@RequestBody MdmIconReqVo mdmIconReqVo) {
    IconDto iconDto = this.nebulaToolkitService.copyObjectByBlankList(mdmIconReqVo, IconDto.class, HashSet.class, LinkedList.class);
    iconController.createByIconDto(iconDto);
  }


  /**
   * hefan:
   * 根据 【id】 【iconCode】 查询一条信息
   *
   * @param id
   * @param iconCode
   * @return
   */
  @ApiImplicitParams({
      @ApiImplicitParam(name = "id", value = "id", required = false, paramType = "query"),
      @ApiImplicitParam(name = "iconCode", value = "图标编码", required = false, paramType = "query"),
  })
  @ApiOperation(value = "查询")
  @GetMapping("/query")
  public void query(@RequestParam(value = "id", required = false) String id,
                                     @RequestParam(value = "iconCode", required = false) String iconCode) {
    this.iconVoController.findByIdOrIconCode(id, iconCode);
  }

  /**
   * hefan: 修改图标
   *
   * @param mdmIconReqVo
   * @return
   */
  @ApiOperation(value = "更新")
  @PostMapping("/update")
  public void update(@RequestBody MdmIconReqVo mdmIconReqVo) {
    IconDto iconDto = this.nebulaToolkitService.copyObjectByBlankList(mdmIconReqVo, IconDto.class, HashSet.class, LinkedList.class);
    this.iconController.updateByIconDto(iconDto);
  }

  /**
   * hefan:
   * 根据id集合删除
   *
   * @param ids
   * @return
   */
  @ApiImplicitParams({
      @ApiImplicitParam(name = "ids", value = "id集合", required = true, paramType = "body")
  })
  @ApiOperation(value = "删除")
  @PostMapping("/delete")
  public void delete(@RequestBody List<String> ids) {
    this.iconController.deleteByIdIn(ids);
  }

}
