package com.bizunited.nebula.icon.local.entity;

import com.bizunited.nebula.common.entity.UuidOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;

/**
 * 图标实体类
 *
 * @author zxw
 * @date 2020-12-05 11:10:24
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "IconEntity", description = "图标实体类")
@Entity
@org.hibernate.annotations.Table(appliesTo = "`engine_icon`", comment = "图标实体类")
@Table(name = "`engine_icon`")
public class IconEntity extends UuidOpEntity {
  private static final long serialVersionUID = -5128751379441707513L;

  /**
   * 图标编码
   */
  @ApiModelProperty("图标编码")
  @Column(name = "icon_code", nullable = false, length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 图标编码 '")
  private String iconCode;

  /**
   * 图标路径
   */
  @ApiModelProperty("图标路径")
  @Column(name = "icon_url", nullable = true, length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 图标路径 '")
  private String iconUrl;

  /**
   * 图标名称
   */
  @ApiModelProperty("图标名称")
  @Column(name = "icon_name", nullable = false, length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 图标名称 '")
  private String iconName;

  /**
   * 图标类型
   */
  @ApiModelProperty("图标类型")
  @Column(name = "icon_type", nullable = false, length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 图标类型 '")
  private String iconType;

  /**
   * 图标后缀
   */
  @ApiModelProperty("图标后缀")
  @Column(name = "icon_suffix", nullable = true, length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 图标后缀 '")
  private String iconSuffix;

  /**
   * 图标样式
   */
  @ApiModelProperty("图标样式")
  @Column(name = "icon_style", nullable = false, length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 图标样式 '")
  private String iconStyle;

  /**
   * 图标效果
   */
  @ApiModelProperty("图标效果")
  @Column(name = "icon_effect", nullable = true, length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 图标效果 '")
  private String iconEffect;

  /**
   * 备注
   */
  @ApiModelProperty("备注")
  @Column(name = "remark", nullable = true, length = 400, columnDefinition = "varchar(400) COMMENT '备注'")
  private String remark;
}
