package com.bizunited.nebula.icon.local.repository;

import com.bizunited.nebula.icon.local.entity.IconEntity;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.stereotype.Repository;

import java.util.List;

/**
 * @author hefan
 */
@Repository
public interface IconRepository extends
    IconRepositoryCustom,
    JpaRepository<IconEntity, String>,
    JpaSpecificationExecutor<IconEntity> {


  /**
   * 根据 IconCode 统计
   *
   * @param iconCode
   * @return
   */
  public Integer countByIconCode(String iconCode);

  /**
   * 根据 【id】 【iconCode】 查询一条信息
   *
   * @param id
   * @param iconCode
   * @return
   */
  public IconEntity findByIdOrIconCode(String id, String iconCode);

  /**
   * 根据 id 统计
   *
   * @param id
   * @return
   */
  public Integer countById(String id);

  /**
   * 根据 iconCode 查询 ID
   *
   * @param iconCode
   * @return
   */
  public List<IconEntity> findIdByIconCode(String iconCode);

  /**
   * 根据 id集合 删除
   * @param ids
   */
  void deleteByIdIn(List<String> ids);

  /**
   * 根据 iconCode集合 查询
   *
   * @param iconCodes
   * @return
   */
  List<IconEntity> findByIconCodeIn(List<String> iconCodes);
}
