package com.bizunited.nebula.icon.local.repository.internal;

import com.bizunited.nebula.common.repository.PageRepositoryImpl;
import com.bizunited.nebula.icon.local.entity.IconEntity;
import com.bizunited.nebula.icon.local.repository.IconRepositoryCustom;
import com.bizunited.nebula.icon.sdk.dto.IconPaginationDto;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Repository;

import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import java.util.HashMap;
import java.util.Map;

@Repository
public class IconRepositoryImpl implements IconRepositoryCustom, PageRepositoryImpl {

  @Autowired
  @PersistenceContext
  private EntityManager entityManager;

  @Override
  public Page<IconEntity> findByCondition(Pageable pageable, IconPaginationDto iconPaginationDto) {
    /**
     * 目前的查询条件是：图标名称（模糊）、图标类型
     */
    StringBuilder hql = new StringBuilder("from IconEntity co where 1=1 ");
    StringBuilder countHql = new StringBuilder("select count(*) from IconEntity co where 1=1 ");
    StringBuilder condition = new StringBuilder();
    Map<String, Object> parameter = new HashMap<>();
    if (iconPaginationDto != null) {
      // 图标名称
      if (StringUtils.isNotBlank(iconPaginationDto.getIconName())) {
        condition.append(" AND co.iconName like CONCAT('%', :iconName,'%') ");
        parameter.put("iconName", iconPaginationDto.getIconName());
      }
      //图标类型
      if (StringUtils.isNotBlank(iconPaginationDto.getIconType())) {
        condition.append(" AND co.iconType = :iconType ");
        parameter.put("iconType", iconPaginationDto.getIconType());
      }
    }
    Sort sort = Sort.by(Sort.Direction.DESC, "createTime");
    String sortStr = getSort(pageable, sort, "co");
    hql.append(condition).append(sortStr);
    //hql.append(condition).append(" order by co.create_time desc ");
    countHql.append(condition);
    return queryByConditions(entityManager, hql.toString(), countHql.toString(), parameter, pageable, false, null);
  }
} 
