package com.bizunited.nebula.icon.local.service.internal;

import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.icon.local.entity.IconEntity;
import com.bizunited.nebula.icon.local.repository.IconRepository;
import com.bizunited.nebula.icon.sdk.dto.IconPaginationDto;
import com.bizunited.nebula.icon.sdk.service.IconVoService;
import com.bizunited.nebula.icon.sdk.vo.IconVo;
import com.google.common.collect.Lists;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;

/**
 * @author hefan
 */
@Service
public class IconVoServiceImpl implements IconVoService {

  @Autowired
  private IconRepository iconRepository;
  @Autowired
  private NebulaToolkitService nebulaToolkitService;

  @Override
  public Page<IconVo> findByCondition(Pageable pageable, IconPaginationDto iconPaginationDto) {
    if (Objects.isNull(iconPaginationDto)) {
      return null;
    }
    Page<IconEntity> page = this.iconRepository.findByCondition(pageable, iconPaginationDto);
    List<IconEntity> content = page.getContent();
    if (CollectionUtils.isEmpty(content)) {
     return new PageImpl<>(Lists.newLinkedList(), pageable, page.getTotalElements());
    }
    List<IconVo> iconVos = (List<IconVo>) this.nebulaToolkitService.copyCollectionByBlankList(content, IconEntity.class, IconVo.class, HashSet.class, LinkedList.class);
    return new PageImpl<>(iconVos, pageable, page.getTotalElements());
  }

  @Override
  public IconVo findByIdOrIconCode(String id, String iconCode) {
    if (StringUtils.isEmpty(id) && StringUtils.isEmpty(iconCode)) {
      return null;
    }
    IconEntity one = this.iconRepository.findByIdOrIconCode(id, iconCode);
    IconVo iconVo = this.nebulaToolkitService.copyObjectByBlankList(one, IconVo.class, HashSet.class, LinkedList.class);
    return iconVo;
  }

  @Override
  public List<IconVo> findByIconCodeIn(List<String> iconCodes) {
    if (CollectionUtils.isEmpty(iconCodes)) {
      return null;
    }
    List<IconEntity> byIconCodeIn = this.iconRepository.findByIconCodeIn(iconCodes);
    List<IconVo> iconVos = (List<IconVo>)this.nebulaToolkitService.copyCollectionByBlankList(byIconCodeIn, IconEntity.class, IconVo.class, HashSet.class, LinkedList.class);
    return iconVos;
  }
}
