package com.bizunited.nebula.icon.sdk.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;

import java.util.List;

/**
 * 图标DTO
 *
 * @author hefan
 */
@Data
@NoArgsConstructor
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "IconDto", description = "图标DTO")
public class IconDto {

  /**
   * 主键ID
   */
  @ApiModelProperty(name = "id", value = "主键ID")
  private String id;

  /**
   * 数据状态（删除状态）
   */
  private String delFlag;

  /**
   * 数据业务状态（启用状态）
   */
  private String enableStatus;

  /**
   * 备注
   */
  private String remark;

  /**
   * 租户编号
   */
  @ApiModelProperty(name = "tenantCode", value = "租户编号")
  private String tenantCode;

  private List<String> iconCodeList;

  @ApiModelProperty("图标编码")
  private String iconCode;

  @ApiModelProperty("图标路径")
  private String iconUrl;

  @ApiModelProperty("图标名称")
  private String iconName;

  @ApiModelProperty("图标类型")
  private String iconType;

  @ApiModelProperty("图标后缀")
  private String iconSuffix;

  @ApiModelProperty("图标样式")
  private String iconStyle;

  @ApiModelProperty("图标效果")
  private String iconEffect;

}
