package com.bizunited.nebula.icon.sdk.service;

import com.bizunited.nebula.icon.sdk.dto.IconPaginationDto;
import com.bizunited.nebula.icon.sdk.vo.IconVo;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;

import java.util.List;

/**
 * @author hefan
 */
public interface IconVoService {
  /**
   * 分页 动态条件查询
   *
   * @param pageable
   * @param iconPaginationDto
   * @return
   */
  Page<IconVo> findByCondition(Pageable pageable, IconPaginationDto iconPaginationDto);

  /**
   * 根据 【id】 【iconCode】 查询一条信息
   *
   * @param id
   * @param iconCode
   * @return
   */
  IconVo findByIdOrIconCode(String id, String iconCode);

  /**
   * 根据 iconCode集合 查询
   *
   * @param iconCodes
   * @return
   */
  List<IconVo> findByIconCodeIn(List<String> iconCodes);
}
