/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.nebula.init.service;

import com.bizunited.nebula.common.configuration.SimpleTenantProperties;
import com.bizunited.nebula.datasource.entity.AppDataSource;
import com.bizunited.nebula.datasource.service.AppDataSourceService;
import com.bizunited.nebula.init.service.InitProcessEnvironmentForAppCodeTask;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class InitProcessEnvironmentHandle {
    @Autowired
    private SimpleTenantProperties simpleTenantProperties;
    @Autowired
    private InitProcessEnvironmentForAppCodeTask initProcessEnvironmentForAppCodeTask;
    @Autowired
    private AppDataSourceService appDataSourceService;

    public void initAll() {
        List appDataSources = this.appDataSourceService.findByTstatus();
        if (CollectionUtils.isEmpty((Collection)appDataSources)) {
            appDataSources = Lists.newArrayList();
        }
        Set appCodes = appDataSources.stream().map(AppDataSource::getAppCode).collect(Collectors.toSet());
        if (this.simpleTenantProperties.getIncludeDefaultAppcode().booleanValue()) {
            String defaultAppCode = this.simpleTenantProperties.getDefaultAppCode();
            appCodes.add(defaultAppCode);
        }
        for (String appCode : appCodes) {
            this.initProcessEnvironmentForAppCodeTask.init(appCode);
        }
    }

    public void initForAppCode(String appCode) {
    }

    public void initForTenantCode(String appCode, String tenantCode) {
    }
}

