/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.nebula.init.configuration;

import com.bizunited.nebula.datasource.service.AppDataSourceService;
import com.bizunited.nebula.init.service.InitProcessEnvironmentHandle;
import com.bizunited.nebula.init.service.InitProcessEnvironmentThreadFactory;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.CommandLineRunner;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.stereotype.Component;

@Configuration
@Component(value="systemInitConfig")
@ComponentScan(basePackages={"com.bizunited.nebula.init"})
public class SystemInitConfig
implements CommandLineRunner {
    @Autowired
    private InitProcessEnvironmentHandle initProcessEnvironmentHandle;

    public void run(String ... args) throws Exception {
        this.initProcessEnvironmentHandle.initAll();
    }

    @Bean(value={"initProcessThreadPoolExecutor"})
    @ConditionalOnMissingBean(name={"initProcessThreadPoolExecutor"})
    public ThreadPoolExecutor getInitProcessThreadPoolExecutor(AppDataSourceService appDataSourceService, InitProcessEnvironmentThreadFactory threadFactory) {
        ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(5, 10, 1L, TimeUnit.MINUTES, new LinkedBlockingDeque<Runnable>(), threadFactory);
        return threadPoolExecutor;
    }
}

