/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.nebula.mars.local.service.internal;

import com.bizunited.nebula.mars.local.entity.MarsAuthorityExcludedFieldDetailEntity;
import com.bizunited.nebula.mars.local.repository.MarsAuthorityExcludedFieldDetailRepository;
import com.bizunited.nebula.mars.sdk.service.MarsAuthorityExcludedFieldDetailService;
import com.bizunited.nebula.mars.sdk.service.MarsAuthorityService;
import com.bizunited.nebula.mars.sdk.vo.MarsAuthority;
import com.bizunited.nebula.mars.sdk.vo.MarsAuthorityExcludedFieldDetail;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class MarsAuthorityExcludedFieldDetailServiceImpl
implements MarsAuthorityExcludedFieldDetailService {
    @Autowired
    private MarsAuthorityExcludedFieldDetailRepository marsAuthorityExcludedFieldDetailRepository;
    @Autowired
    private MarsAuthorityService marsAuthorityService;

    public Set<String> findByListCode(String listCode) {
        if (StringUtils.isBlank((CharSequence)listCode)) {
            return null;
        }
        Set marsAuthoritors = this.marsAuthorityService.findByListCodeAndCurrentUser(listCode);
        if (CollectionUtils.isEmpty((Collection)marsAuthoritors)) {
            return null;
        }
        Set<String> marsAuthorityCodes = marsAuthoritors.stream().filter(item -> item.getStatus() == 1 && StringUtils.isNotBlank((CharSequence)item.getCode())).map(MarsAuthority::getCode).collect(Collectors.toSet());
        return this.findByMarsAuthorityCodes(marsAuthorityCodes);
    }

    public Set<String> findByMarsAuthorityCodes(Set<String> marsAuthorityCodes) {
        if (CollectionUtils.isEmpty(marsAuthorityCodes)) {
            return null;
        }
        Set<MarsAuthorityExcludedFieldDetailEntity> marsAuthorityExcludedFieldDetails = this.marsAuthorityExcludedFieldDetailRepository.findByMarsAuthorityCodes(marsAuthorityCodes);
        if (CollectionUtils.isEmpty(marsAuthorityExcludedFieldDetails)) {
            return null;
        }
        return marsAuthorityExcludedFieldDetails.stream().map(MarsAuthorityExcludedFieldDetailEntity::getExcludedField).collect(Collectors.toSet());
    }

    public Set<MarsAuthorityExcludedFieldDetail> findByListCodes(String listCode) {
        if (StringUtils.isBlank((CharSequence)listCode)) {
            return null;
        }
        Set marsAuthoritors = this.marsAuthorityService.findByListCodeAndCurrentUser(listCode);
        if (CollectionUtils.isEmpty((Collection)marsAuthoritors)) {
            return null;
        }
        Set<String> marsAuthorityCodes = marsAuthoritors.stream().filter(item -> item.getStatus() == 1 && StringUtils.isNotBlank((CharSequence)item.getCode())).map(MarsAuthority::getCode).collect(Collectors.toSet());
        Set<MarsAuthorityExcludedFieldDetailEntity> marsAuthorityExcludedFieldDetails = this.marsAuthorityExcludedFieldDetailRepository.findByMarsAuthorityCodes(marsAuthorityCodes);
        if (CollectionUtils.isEmpty(marsAuthorityExcludedFieldDetails)) {
            return null;
        }
        LinkedHashSet marsAuthorityExcludedFieldDetailVos = Sets.newLinkedHashSet();
        for (MarsAuthorityExcludedFieldDetailEntity marsAuthorityExcludedFieldDetailEntity : marsAuthorityExcludedFieldDetails) {
            MarsAuthorityExcludedFieldDetail item2 = new MarsAuthorityExcludedFieldDetail();
            item2.setExcludedField(marsAuthorityExcludedFieldDetailEntity.getExcludedField());
            item2.setMarsAuthorityId(marsAuthorityExcludedFieldDetailEntity.getMarsAuthority().getId());
        }
        return marsAuthorityExcludedFieldDetailVos;
    }
}

