/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.nebula.mars.local.service.internal;

import com.bizunited.nebula.common.service.CopyObjectCallback;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.mars.local.entity.MarsAuthorityDetailEntity;
import com.bizunited.nebula.mars.local.entity.MarsAuthorityEntity;
import com.bizunited.nebula.mars.local.repository.MarsAuthorityRepository;
import com.bizunited.nebula.mars.local.service.MarsAuthorityQueryService;
import com.bizunited.nebula.mars.local.vo.MarsAuthorityQueryVo;
import com.bizunited.nebula.mars.sdk.register.SelectAuthorityModeRegister;
import com.bizunited.nebula.mars.sdk.register.SelectScopeRegister;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class MarsAuthorityQueryServiceImpl
implements MarsAuthorityQueryService,
CopyObjectCallback<MarsAuthorityEntity, MarsAuthorityQueryVo> {
    @Autowired
    private MarsAuthorityRepository marsAuthorityRepository;
    @Autowired
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    @Lazy
    private Set<SelectScopeRegister> selectScopeRegisters;
    @Autowired(required=false)
    @Lazy
    private Set<SelectAuthorityModeRegister> selectAuthorityModeRegisters;

    @Override
    public Page<MarsAuthorityQueryVo> findByConditions(Pageable pageable, MarsAuthorityQueryVo condition) {
        if (pageable == null) {
            pageable = PageRequest.of((int)0, (int)20);
        }
        condition.setTenantCode(TenantUtils.getTenantCode());
        Page<MarsAuthorityEntity> results = this.marsAuthorityRepository.findByConditions(pageable, condition);
        if (results == null || results.isEmpty()) {
            return null;
        }
        Collection marsAuthorityQuerys = this.nebulaToolkitService.copyCollectionByWhiteList(results, MarsAuthorityEntity.class, MarsAuthorityQueryVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        for (MarsAuthorityQueryVo marsAuthorityQueryVo : marsAuthorityQuerys) {
            String scopeKey = marsAuthorityQueryVo.getScopeKey();
            CharSequence[] selectModeKeys = marsAuthorityQueryVo.getSelectModeKeys();
            if (StringUtils.isNotBlank((CharSequence)scopeKey) && !CollectionUtils.isEmpty(this.selectScopeRegisters)) {
                for (SelectScopeRegister selectScopeRegister : this.selectScopeRegisters) {
                    if (!StringUtils.equals((CharSequence)selectScopeRegister.scopeKey(), (CharSequence)scopeKey)) continue;
                    marsAuthorityQueryVo.setScopeName(selectScopeRegister.selectName());
                }
            }
            if (selectModeKeys == null || CollectionUtils.isEmpty(this.selectAuthorityModeRegisters)) continue;
            ArrayList selectModeNames = Lists.newArrayList();
            for (SelectAuthorityModeRegister selectAuthorityModeRegister : this.selectAuthorityModeRegisters) {
                if (!StringUtils.equalsAny((CharSequence)selectAuthorityModeRegister.modeKey(), (CharSequence[])selectModeKeys)) continue;
                selectModeNames.add(selectAuthorityModeRegister.modeName());
            }
            marsAuthorityQueryVo.setSelectModeNames(selectModeNames.toArray(new String[0]));
        }
        return new PageImpl((List)Lists.newArrayList((Iterable)marsAuthorityQuerys), pageable, results.getTotalElements());
    }

    public boolean validate(Class<?> sourceClass, Class<?> targetClass) {
        return sourceClass == MarsAuthorityEntity.class && targetClass == MarsAuthorityQueryVo.class;
    }

    public void callback(Class<MarsAuthorityEntity> sourceClass, List<MarsAuthorityEntity> sourceObjects, Class<MarsAuthorityQueryVo> targetClass, List<MarsAuthorityQueryVo> targetObjects) {
        for (int index = 0; index < sourceObjects.size(); ++index) {
            MarsAuthorityEntity marsAuthorityEntity = sourceObjects.get(index);
            MarsAuthorityQueryVo marsAuthorityQueryVo = targetObjects.get(index);
            Set<MarsAuthorityDetailEntity> marsAuthorityDetails = marsAuthorityEntity.getMarsSelectDetails();
            if (CollectionUtils.isEmpty(marsAuthorityDetails)) continue;
            String[] selectModeKeys = (String[])marsAuthorityDetails.stream().map(MarsAuthorityDetailEntity::getSelectModeKey).toArray(String[]::new);
            marsAuthorityQueryVo.setSelectModeKeys(selectModeKeys);
        }
    }
}

