/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.nebula.mars.local.service.internal;

import com.bizunited.nebula.common.service.CopyObjectCallback;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.mars.local.entity.MarsAuthorityDetailEntity;
import com.bizunited.nebula.mars.local.entity.MarsAuthorityEntity;
import com.bizunited.nebula.mars.local.entity.MarsAuthorityExcludedFieldDetailEntity;
import com.bizunited.nebula.mars.local.repository.MarsAuthorityDetailRepository;
import com.bizunited.nebula.mars.local.repository.MarsAuthorityExcludedFieldDetailRepository;
import com.bizunited.nebula.mars.local.repository.MarsAuthorityRepository;
import com.bizunited.nebula.mars.sdk.dto.MarsAuthorityDetailDto;
import com.bizunited.nebula.mars.sdk.dto.MarsAuthorityDto;
import com.bizunited.nebula.mars.sdk.dto.MarsAuthorityExcludedFieldDetailDto;
import com.bizunited.nebula.mars.sdk.event.MarsAuthorityEventListener;
import com.bizunited.nebula.mars.sdk.register.SelectAuthorityModeGroupRegister;
import com.bizunited.nebula.mars.sdk.register.SelectAuthorityModeRegister;
import com.bizunited.nebula.mars.sdk.register.SelectScopeRegister;
import com.bizunited.nebula.mars.sdk.service.MarsAuthorityService;
import com.bizunited.nebula.mars.sdk.service.SelectScopeRegisterService;
import com.bizunited.nebula.mars.sdk.vo.MarsAuthority;
import com.bizunited.nebula.mars.sdk.vo.MarsAuthorityDetail;
import com.bizunited.nebula.mars.sdk.vo.MarsAuthorityExcludedFieldDetail;
import com.bizunited.nebula.mars.sdk.vo.SelectScopeRegisterVo;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.transaction.Transactional;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Lazy
@Component(value="marsAuthorityService")
public class MarsAuthorityServiceImpl
implements MarsAuthorityService,
CopyObjectCallback<MarsAuthorityEntity, MarsAuthority> {
    @Autowired
    private MarsAuthorityRepository marsAuthorityRepository;
    @Autowired
    private MarsAuthorityDetailRepository marsAuthorityDetailRepository;
    @Autowired
    private MarsAuthorityExcludedFieldDetailRepository marsAuthorityExcludedFieldDetailRepository;
    @Autowired(required=false)
    @Lazy
    private List<SelectScopeRegister> selectScopeRegisters;
    @Autowired(required=false)
    @Lazy
    private List<SelectAuthorityModeGroupRegister> selectAuthorityModeGroupRegisters;
    @Autowired(required=false)
    @Lazy
    private List<SelectAuthorityModeRegister> selectAuthorityModeRegisters;
    @Autowired(required=false)
    private SelectScopeRegisterService selectScopeRegisterService;
    @Autowired
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private List<MarsAuthorityEventListener> eventListeners;

    @Transactional
    public MarsAuthority create(MarsAuthorityDto marsAuthorityDto) {
        Validate.notNull((Object)marsAuthorityDto, (String)"\u6570\u636e\u6743\u9650\u6dfb\u52a0\u65f6\uff0c\u53d1\u73b0\u9519\u8bef\u7684\u8f93\u5165\u53c2\u6570", (Object[])new Object[0]);
        String id = marsAuthorityDto.getId();
        Validate.isTrue((boolean)StringUtils.isBlank((CharSequence)id), (String)"\u6570\u636e\u6743\u9650\u521b\u5efa\u65f6\uff0c\u4e0d\u5141\u8bb8\u4f20\u5165\u6570\u636e\u6743\u9650\u7684\u6280\u672f\u7f16\u53f7\uff08id\uff09", (Object[])new Object[0]);
        String code = marsAuthorityDto.getCode();
        Validate.notBlank((CharSequence)code, (String)"\u6570\u636e\u6743\u9650\u6dfb\u52a0\u65f6\uff0c\u53d1\u73b0\u6ca1\u6709\u8bbe\u5b9a\u4fe1\u606f\u7684\u4e1a\u52a1\u7f16\u53f7!!", (Object[])new Object[0]);
        MarsAuthorityEntity exist = this.marsAuthorityRepository.findByCodeAndTenantCode(code, TenantUtils.getTenantCode());
        Validate.isTrue((exist == null ? 1 : 0) != 0, (String)"\u6570\u636e\u6743\u9650\u6dfb\u52a0\u65f6\uff0c\u53d1\u73b0\u4e1a\u52a1\u7f16\u53f7\u5df2\u7ecf\u88ab\u4f7f\u7528\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        MarsAuthority marsAuthority = (MarsAuthority)this.nebulaToolkitService.copyObjectByWhiteList((Object)marsAuthorityDto, MarsAuthority.class, LinkedHashSet.class, ArrayList.class, new String[]{"marsSelectDetails"});
        marsAuthority.setScopeValues(marsAuthorityDto.getScopeValues());
        Set marsAuthorityDetailDtos = marsAuthorityDto.getMarsSelectDetails();
        if (CollectionUtils.isEmpty((Collection)marsAuthorityDetailDtos)) {
            marsAuthorityDetailDtos = Sets.newLinkedHashSet();
        }
        Map<String, MarsAuthorityDetailDto> marsAuthorityDetailDtoMapping = marsAuthorityDetailDtos.stream().collect(Collectors.toMap(MarsAuthorityDetailDto::getSelectModeKey, item -> item));
        Set marsAuthorityDetails = marsAuthority.getMarsSelectDetails();
        if (CollectionUtils.isEmpty((Collection)marsAuthorityDetails)) {
            marsAuthorityDetails = Sets.newLinkedHashSet();
        }
        Map<String, MarsAuthorityDetail> marsAuthorityDetailMapping = marsAuthorityDetails.stream().collect(Collectors.toMap(MarsAuthorityDetail::getSelectModeKey, item -> item));
        for (Map.Entry<String, MarsAuthorityDetailDto> marsAuthorityDetailDtoEntry : marsAuthorityDetailDtoMapping.entrySet()) {
            String selectModeKey = marsAuthorityDetailDtoEntry.getKey();
            MarsAuthorityDetailDto marsAuthorityDetailDto = marsAuthorityDetailDtoEntry.getValue();
            MarsAuthorityDetail marsAuthorityDetail = marsAuthorityDetailMapping.get(selectModeKey);
            if (marsAuthorityDetailDto == null || marsAuthorityDetailDto == null) continue;
            marsAuthorityDetail.setSelectModeValues(marsAuthorityDetailDto.getSelectModeValues());
        }
        this.validate(marsAuthority, "\u6570\u636e\u6743\u9650\u6dfb\u52a0\u65f6");
        Object[] scopeValues = marsAuthority.getScopeValues();
        Validate.isTrue((scopeValues != null && scopeValues.length > 0 ? 1 : 0) != 0, (String)"\u6570\u636e\u6743\u9650\u6dfb\u52a0\u65f6\uff0c\u81f3\u5c11\u6709\u4e00\u4e2a\u9009\u5b9a\u7684\u4e1a\u52a1\u8303\u56f4\uff0c\u6ca1\u6709\u6309\u7167\u8981\u6c42\u4f20\u5165\u4e1a\u52a1\u503c\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        String tenantCode = TenantUtils.getTenantCode();
        marsAuthority.setTenantCode(tenantCode);
        SecurityContext securityContext = SecurityContextHolder.getContext();
        String userAccount = "admin";
        Authentication authentication = securityContext.getAuthentication();
        if (authentication != null) {
            userAccount = authentication.getName();
        }
        marsAuthority.setCreateAccount(userAccount);
        marsAuthority.setModifyAccount(userAccount);
        Date now = new Date();
        marsAuthority.setCreateTime(now);
        marsAuthority.setModifyTime(now);
        marsAuthority.setStatus(Integer.valueOf(1));
        MarsAuthorityEntity marsAuthorityEntity = (MarsAuthorityEntity)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)marsAuthority, MarsAuthorityEntity.class, LinkedHashSet.class, ArrayList.class, new String[0]));
        marsAuthorityEntity.setStatus(1);
        marsAuthorityEntity.setTenantCode(tenantCode);
        marsAuthorityEntity.setScopeValues(StringUtils.join((Object[])scopeValues, (String)","));
        this.marsAuthorityRepository.save((Object)marsAuthorityEntity);
        marsAuthority.setId(marsAuthorityEntity.getId());
        Set excludedFieldDetails = marsAuthorityDto.getExcludedFieldDetails();
        if (CollectionUtils.isEmpty((Collection)marsAuthorityDetails) && CollectionUtils.isEmpty((Collection)excludedFieldDetails)) {
            throw new IllegalArgumentException("\u521b\u5efa\u6570\u636e\u6743\u9650\u65f6\uff0c\u8981\u4e48\u9700\u8bbe\u5b9a\u6570\u636e\u9879\u9009\u9879\uff0c\u8981\u4e48\u5f90\u8bbe\u5b9a\u6392\u9664\u7684\u5217\u8868\u9009\u9879");
        }
        if (!CollectionUtils.isEmpty((Collection)marsAuthorityDetails)) {
            this.buildMarsAuthorityDetail(marsAuthorityDetails, marsAuthorityEntity, "\u6570\u636e\u6743\u9650\u6dfb\u52a0\u65f6");
        }
        if (!CollectionUtils.isEmpty((Collection)excludedFieldDetails)) {
            this.buildMarsAuthorityExcludedFieldDetail(excludedFieldDetails, marsAuthorityEntity, "\u6570\u636e\u6743\u9650\u6dfb\u52a0\u65f6");
        }
        if (!CollectionUtils.isEmpty(this.eventListeners)) {
            MarsAuthority authority = this.buildMarsAuthority(marsAuthorityEntity.getId());
            this.eventListeners.forEach(eventListener -> eventListener.onCreated(authority));
        }
        return marsAuthority;
    }

    private void buildMarsAuthorityExcludedFieldDetail(Set<MarsAuthorityExcludedFieldDetailDto> excludedFieldDetails, MarsAuthorityEntity marsAuthorityEntity, String onTime) {
        for (MarsAuthorityExcludedFieldDetailDto marsAuthorityExcludedFieldDetailDto : excludedFieldDetails) {
            String excludedField = marsAuthorityExcludedFieldDetailDto.getExcludedField();
            Validate.notBlank((CharSequence)excludedField, (String)(onTime + "\uff0c\u53d1\u73b0\u4e0d\u6b63\u786e\u7684\u201c\u663e\u793a\u5b57\u6bb5\u6392\u9664\u4fe1\u606f\u201d\uff0c\u8bf7\u68c0\u67e5!!"), (Object[])new Object[0]);
            MarsAuthorityExcludedFieldDetailEntity excludedFieldDetailEntity = new MarsAuthorityExcludedFieldDetailEntity();
            excludedFieldDetailEntity.setExcludedField(excludedField);
            excludedFieldDetailEntity.setMarsAuthority(marsAuthorityEntity);
            this.marsAuthorityExcludedFieldDetailRepository.save((Object)excludedFieldDetailEntity);
        }
    }

    private void buildMarsAuthorityDetail(Set<MarsAuthorityDetail> marsAuthorityDetails, MarsAuthorityEntity marsAuthorityEntity, String onTime) {
        for (MarsAuthorityDetail marsAuthorityDetailItem : marsAuthorityDetails) {
            String selectModeGroupCode = marsAuthorityDetailItem.getSelectModeGroupCode();
            Validate.notBlank((CharSequence)selectModeGroupCode, (String)(onTime + "\uff0c\u81f3\u5c11\u6709\u4e00\u4e2a\u6570\u636e\u6743\u9650\u9879\u76ee\u7684\u9879\u76ee\u5206\u7ec4\uff08selectModeGroupCode\uff09\u6ca1\u6709\u586b\u5199\uff0c\u8bf7\u68c0\u67e5!!"), (Object[])new Object[0]);
            boolean existSelectAuthorityModeGroupRegister = false;
            for (SelectAuthorityModeGroupRegister selectAuthorityModeGroupRegister : this.selectAuthorityModeGroupRegisters) {
                if (!StringUtils.equals((CharSequence)selectAuthorityModeGroupRegister.groupCode(), (CharSequence)selectModeGroupCode)) continue;
                existSelectAuthorityModeGroupRegister = true;
                break;
            }
            Validate.isTrue((boolean)existSelectAuthorityModeGroupRegister, (String)(onTime + "\uff0c\u81f3\u5c11\u6709\u4e00\u4e2a\u6570\u636e\u6743\u9650\u9879\u76ee\u7684\u9879\u76ee\u5206\u7ec4\u5e76\u6ca1\u6709\u6ce8\u518c\uff0c\u8bf7\u68c0\u67e5!!"), (Object[])new Object[0]);
            String selectModeKey = marsAuthorityDetailItem.getSelectModeKey();
            Validate.notBlank((CharSequence)selectModeKey, (String)(onTime + "\uff0c\u81f3\u5c11\u6709\u4e00\u4e2a\u6570\u636e\u6743\u9650\u7684\u9879\u76ee\u9009\u62e9\u65b9\u5f0f\u7684key\u6ca1\u6709\u586b\u5199\uff0c\u8bf7\u68c0\u67e5!!"), (Object[])new Object[0]);
            SelectAuthorityModeRegister selectAuthorityModeRegister = null;
            for (SelectAuthorityModeRegister selectAuthorityModeRegisterItem : this.selectAuthorityModeRegisters) {
                if (!StringUtils.equals((CharSequence)selectAuthorityModeRegisterItem.modeKey(), (CharSequence)selectModeKey)) continue;
                selectAuthorityModeRegister = selectAuthorityModeRegisterItem;
                break;
            }
            Validate.notNull((Object)selectAuthorityModeRegister, (String)(onTime + "\uff0c\u81f3\u5c11\u6709\u4e00\u4e2a\u6570\u636e\u6743\u9650\u7684\u9009\u62e9\u65b9\u5f0f\u6ca1\u6709\u6b63\u786e\u586b\u5199\u9009\u62e9\u9879\u7684key\uff08selectModeKey\uff09"), (Object[])new Object[0]);
            Object[] selectModeValues = null;
            if (selectAuthorityModeRegister.isStaticValue()) {
                selectModeValues = marsAuthorityDetailItem.getSelectModeValues();
                Validate.isTrue((selectModeValues != null && selectModeValues.length > 0 ? 1 : 0) != 0, (String)(onTime + "\uff0c\u81f3\u5c11\u6709\u4e00\u4e2a\u6570\u636e\u6743\u9650\u7684\u9009\u62e9\u65b9\u5f0f\uff0c\u6ca1\u6709\u6309\u7167\u8981\u6c42\u4f20\u5165\u4e1a\u52a1\u503c\uff0c\u8bf7\u68c0\u67e5!!"), (Object[])new Object[0]);
            }
            MarsAuthorityDetailEntity marsAuthorityDetailEntity = new MarsAuthorityDetailEntity();
            marsAuthorityDetailEntity.setMarsAuthority(marsAuthorityEntity);
            marsAuthorityDetailEntity.setSelectModeGroupCode(selectModeGroupCode);
            marsAuthorityDetailEntity.setSelectModeKey(selectModeKey);
            marsAuthorityDetailEntity.setSelectModeValues(selectModeValues != null ? StringUtils.join((Object[])selectModeValues, (String)",") : null);
            this.marsAuthorityDetailRepository.save((Object)marsAuthorityDetailEntity);
            marsAuthorityDetailItem.setId(marsAuthorityDetailEntity.getId());
        }
    }

    private void validate(MarsAuthority marsAuthority, String onTime) {
        String competenceCode = marsAuthority.getCompetenceCode();
        Validate.notBlank((CharSequence)competenceCode, (String)(onTime + "\uff0c\u672a\u53d1\u73b0\u529f\u80fd\u4e1a\u52a1\u7f16\u53f7\uff0c\u8bf7\u68c0\u67e5!!"), (Object[])new Object[0]);
        String listCode = marsAuthority.getListCode();
        Validate.notBlank((CharSequence)listCode, (String)(onTime + "\uff0c\u672a\u53d1\u73b0\u5217\u8868\u4fe1\u606f\u4e1a\u52a1\u7f16\u53f7\uff0c\u8bf7\u68c0\u67e5!!"), (Object[])new Object[0]);
        String name = marsAuthority.getName();
        Validate.notBlank((CharSequence)name, (String)(onTime + "\uff0c\u672a\u53d1\u73b0\u6b63\u786e\u7684\u6570\u636e\u6743\u9650\u540d\u79f0\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!"), (Object[])new Object[0]);
        String scopeKey = marsAuthority.getScopeKey();
        Validate.notBlank((CharSequence)scopeKey, (String)(onTime + "\uff0c\u672a\u53d1\u73b0\u6b63\u786e\u7684\u4e1a\u52a1\u8303\u56f4\u9009\u62e9\u6807\u8bc6\uff0c\u8bf7\u68c0\u67e5!!"), (Object[])new Object[0]);
        boolean exsitSelectScopeRegister = false;
        for (SelectScopeRegister selectScopeRegister : this.selectScopeRegisters) {
            if (!StringUtils.equals((CharSequence)selectScopeRegister.scopeKey(), (CharSequence)scopeKey)) continue;
            exsitSelectScopeRegister = true;
            break;
        }
        Validate.isTrue((boolean)exsitSelectScopeRegister, (String)"\u6570\u636e\u6743\u9650\u6dfb\u52a0\u65f6\uff0c\u672a\u53d1\u73b0\u6b63\u786e\u7684\u4e1a\u52a1\u8303\u56f4\u6ce8\u518c\u5668\uff08exsitSelectScopeRegister\uff1a%s\uff09\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[]{scopeKey});
    }

    @Transactional
    public MarsAuthority update(MarsAuthorityDto marsAuthorityDto) {
        Validate.notNull((Object)marsAuthorityDto, (String)"\u6570\u636e\u6743\u9650\u4fee\u6539\u65f6\uff0c\u53d1\u73b0\u9519\u8bef\u7684\u8f93\u5165\u53c2\u6570", (Object[])new Object[0]);
        String id = marsAuthorityDto.getId();
        Validate.notBlank((CharSequence)id, (String)"\u6570\u636e\u6743\u9650\u4fee\u6539\u65f6\uff0c\u672a\u53d1\u73b0\u4f18\u60e0\u653f\u7b56\u7684\u6280\u672f\u7f16\u53f7id\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        MarsAuthorityEntity exsitMarsAuthorityEntity = this.marsAuthorityRepository.findById(id).orElse(null);
        Validate.notNull((Object)((Object)exsitMarsAuthorityEntity), (String)"\u6570\u636e\u6743\u9650\u4fee\u6539\u65f6\uff0c\u672a\u53d1\u73b0\u4f18\u60e0\u653f\u7b56\u7684\u6280\u672f\u7f16\u53f7\u5bf9\u5e94\u7684\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        MarsAuthority oldAuthority = this.buildMarsAuthority(id);
        MarsAuthority marsAuthority = (MarsAuthority)this.nebulaToolkitService.copyObjectByWhiteList((Object)marsAuthorityDto, MarsAuthority.class, LinkedHashSet.class, ArrayList.class, new String[]{"marsSelectDetails"});
        marsAuthority.setScopeValues(marsAuthorityDto.getScopeValues());
        Set marsAuthorityDetailDtos = marsAuthorityDto.getMarsSelectDetails();
        if (marsAuthorityDetailDtos.isEmpty()) {
            marsAuthorityDetailDtos = Sets.newLinkedHashSet();
        }
        Map<String, MarsAuthorityDetailDto> marsAuthorityDetailDtoMapping = marsAuthorityDetailDtos.stream().collect(Collectors.toMap(MarsAuthorityDetailDto::getSelectModeKey, item -> item));
        Set marsAuthorityDetails = marsAuthority.getMarsSelectDetails();
        if (CollectionUtils.isEmpty((Collection)marsAuthorityDetails)) {
            marsAuthorityDetails = Sets.newLinkedHashSet();
        }
        Map<String, MarsAuthorityDetail> marsAuthorityDetailMapping = marsAuthorityDetails.stream().collect(Collectors.toMap(MarsAuthorityDetail::getSelectModeKey, item -> item));
        for (Map.Entry<String, MarsAuthorityDetailDto> marsAuthorityDetailDtoEntry : marsAuthorityDetailDtoMapping.entrySet()) {
            String selectModeKey = marsAuthorityDetailDtoEntry.getKey();
            MarsAuthorityDetailDto marsAuthorityDetailDto = marsAuthorityDetailDtoEntry.getValue();
            MarsAuthorityDetail marsAuthorityDetail = marsAuthorityDetailMapping.get(selectModeKey);
            if (marsAuthorityDetailDto == null || marsAuthorityDetailDto == null) continue;
            marsAuthorityDetail.setSelectModeValues(marsAuthorityDetailDto.getSelectModeValues());
        }
        SecurityContext securityContext = SecurityContextHolder.getContext();
        String userAccount = "admin";
        Authentication authentication = securityContext.getAuthentication();
        if (authentication != null) {
            userAccount = authentication.getName();
        }
        Date now = new Date();
        Object[] scopeValues = marsAuthority.getScopeValues();
        Validate.isTrue((scopeValues != null && scopeValues.length > 0 ? 1 : 0) != 0, (String)"\u6570\u636e\u6743\u9650\u4fee\u6539\u65f6\uff0c\u81f3\u5c11\u6709\u4e00\u4e2a\u9009\u5b9a\u7684\u4e1a\u52a1\u8303\u56f4\uff0c\u6ca1\u6709\u6309\u7167\u8981\u6c42\u4f20\u5165\u4e1a\u52a1\u503c\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        this.validate(marsAuthority, "\u6570\u636e\u6743\u9650\u4fee\u6539\u65f6");
        exsitMarsAuthorityEntity.setCompetenceCode(marsAuthority.getCompetenceCode());
        exsitMarsAuthorityEntity.setCompetenceName(marsAuthority.getCompetenceName());
        exsitMarsAuthorityEntity.setListCode(marsAuthority.getListCode());
        exsitMarsAuthorityEntity.setListName(marsAuthority.getListName());
        exsitMarsAuthorityEntity.setName(marsAuthority.getName());
        exsitMarsAuthorityEntity.setScopeKey(marsAuthority.getScopeKey());
        exsitMarsAuthorityEntity.setScopeValues(StringUtils.join((Object[])scopeValues, (String)","));
        exsitMarsAuthorityEntity.setModifyAccount(userAccount);
        exsitMarsAuthorityEntity.setModifyTime(now);
        this.marsAuthorityRepository.save((Object)exsitMarsAuthorityEntity);
        Set excludedFieldDetails = marsAuthorityDto.getExcludedFieldDetails();
        if (CollectionUtils.isEmpty((Collection)marsAuthorityDetails) && CollectionUtils.isEmpty((Collection)excludedFieldDetails)) {
            throw new IllegalArgumentException("\u4fee\u6539\u6570\u636e\u6743\u9650\u65f6\uff0c\u8981\u4e48\u9700\u8bbe\u5b9a\u6570\u636e\u9879\u9009\u9879\uff0c\u8981\u4e48\u5f90\u8bbe\u5b9a\u6392\u9664\u7684\u5217\u8868\u9009\u9879");
        }
        this.marsAuthorityDetailRepository.deleteByMarsAuthorityid(id);
        if (!CollectionUtils.isEmpty((Collection)marsAuthorityDetails)) {
            this.buildMarsAuthorityDetail(marsAuthorityDetails, exsitMarsAuthorityEntity, "\u6570\u636e\u6743\u9650\u4fee\u6539\u65f6");
        }
        this.marsAuthorityExcludedFieldDetailRepository.deleteByMarsAuthorityid(id);
        if (!CollectionUtils.isEmpty((Collection)excludedFieldDetails)) {
            this.buildMarsAuthorityExcludedFieldDetail(excludedFieldDetails, exsitMarsAuthorityEntity, "\u6570\u636e\u6743\u9650\u6dfb\u52a0\u65f6");
        }
        if (!CollectionUtils.isEmpty(this.eventListeners)) {
            MarsAuthority newAuthority = this.buildMarsAuthority(id);
            this.eventListeners.forEach(eventListener -> eventListener.onUpdate(oldAuthority, newAuthority));
        }
        return marsAuthority;
    }

    @Transactional
    public void effective(String code) {
        Validate.notBlank((CharSequence)code, (String)"\u6570\u636e\u6743\u9650\u542f\u7528\u65f6\uff0c\u5fc5\u987b\u4f20\u5165\u6570\u636e\u6743\u9650\u7684\u4e1a\u52a1\u7f16\u53f7\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        String tenantCode = TenantUtils.getTenantCode();
        MarsAuthorityEntity marsAuthorityEntity = this.marsAuthorityRepository.findByCodeAndTenantCode(code, tenantCode);
        if (marsAuthorityEntity == null) {
            return;
        }
        MarsAuthority oldAuthority = this.buildMarsAuthority(marsAuthorityEntity.getId());
        marsAuthorityEntity.setStatus(1);
        this.marsAuthorityRepository.save((Object)marsAuthorityEntity);
        if (!CollectionUtils.isEmpty(this.eventListeners)) {
            MarsAuthority newAuthority = this.buildMarsAuthority(marsAuthorityEntity.getId());
            this.eventListeners.forEach(eventListener -> eventListener.onEffective(oldAuthority, newAuthority));
        }
    }

    @Transactional
    public void invalid(String code) {
        Validate.notBlank((CharSequence)code, (String)"\u6570\u636e\u6743\u9650\u7981\u7528\u65f6\uff0c\u5fc5\u987b\u4f20\u5165\u6570\u636e\u6743\u9650\u7684\u4e1a\u52a1\u7f16\u53f7\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        String tenantCode = TenantUtils.getTenantCode();
        MarsAuthorityEntity marsAuthorityEntity = this.marsAuthorityRepository.findByCodeAndTenantCode(code, tenantCode);
        if (marsAuthorityEntity == null) {
            return;
        }
        MarsAuthority oldAuthority = this.buildMarsAuthority(marsAuthorityEntity.getId());
        marsAuthorityEntity.setStatus(0);
        this.marsAuthorityRepository.save((Object)marsAuthorityEntity);
        if (!CollectionUtils.isEmpty(this.eventListeners)) {
            MarsAuthority newAuthority = this.buildMarsAuthority(marsAuthorityEntity.getId());
            this.eventListeners.forEach(eventListener -> eventListener.onInvalid(oldAuthority, newAuthority));
        }
    }

    @Transactional
    public void deleteByCode(String code) {
        Validate.notBlank((CharSequence)code, (String)"\u6570\u636e\u6743\u9650\u5220\u9664\u65f6\uff0c\u5fc5\u987b\u4f20\u5165\u6570\u636e\u6743\u9650\u7684\u4e1a\u52a1\u7f16\u53f7\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        String tenantCode = TenantUtils.getTenantCode();
        MarsAuthorityEntity marsAuthorityEntity = this.marsAuthorityRepository.findByCodeAndTenantCode(code, tenantCode);
        if (marsAuthorityEntity == null) {
            return;
        }
        MarsAuthority deleteMarsAuthority = this.buildMarsAuthority(marsAuthorityEntity.getId());
        this.marsAuthorityDetailRepository.deleteByMarsAuthorityid(marsAuthorityEntity.getId());
        this.marsAuthorityExcludedFieldDetailRepository.deleteByMarsAuthorityid(marsAuthorityEntity.getId());
        this.marsAuthorityRepository.delete((Object)marsAuthorityEntity);
        if (!CollectionUtils.isEmpty(this.eventListeners)) {
            this.eventListeners.forEach(eventListener -> eventListener.onDeleted(deleteMarsAuthority));
        }
    }

    public MarsAuthority findByCode(String code) {
        if (StringUtils.isBlank((CharSequence)code)) {
            return null;
        }
        MarsAuthorityEntity marsAuthorityEntity = this.marsAuthorityRepository.findByCodeAndTenantCode(code, TenantUtils.getTenantCode());
        if (marsAuthorityEntity == null) {
            return null;
        }
        MarsAuthority marsAuthority = (MarsAuthority)this.nebulaToolkitService.copyObjectByWhiteList((Object)marsAuthorityEntity, MarsAuthority.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        return marsAuthority;
    }

    public MarsAuthority findDetailByCode(String code) {
        if (StringUtils.isBlank((CharSequence)code)) {
            return null;
        }
        String tenantCode = TenantUtils.getTenantCode();
        MarsAuthorityEntity marsAuthorityEntity = this.marsAuthorityRepository.findDetailByCode(code, tenantCode);
        if (marsAuthorityEntity == null) {
            return null;
        }
        MarsAuthority marsAuthority = (MarsAuthority)this.nebulaToolkitService.copyObjectByWhiteList((Object)marsAuthorityEntity, MarsAuthority.class, LinkedHashSet.class, ArrayList.class, new String[]{"marsSelectDetails"});
        return marsAuthority;
    }

    public Set<MarsAuthority> findByListCode(String listCode) {
        if (StringUtils.isBlank((CharSequence)listCode)) {
            return null;
        }
        String tenantCode = TenantUtils.getTenantCode();
        Set<MarsAuthorityEntity> marsAuthorityEntities = this.marsAuthorityRepository.findByListCodeAndTenantCode(listCode, tenantCode);
        if (CollectionUtils.isEmpty(marsAuthorityEntities)) {
            return null;
        }
        Collection marsAuthorities = this.nebulaToolkitService.copyCollectionByWhiteList(marsAuthorityEntities, MarsAuthorityEntity.class, MarsAuthority.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        return Sets.newLinkedHashSet((Iterable)marsAuthorities);
    }

    private Set<MarsAuthority> findDetailsByListCode(String listCode) {
        if (StringUtils.isBlank((CharSequence)listCode)) {
            return null;
        }
        String tenantCode = TenantUtils.getTenantCode();
        Set<MarsAuthorityEntity> marsAuthorityEntities = this.marsAuthorityRepository.findDetailByListCode(listCode, tenantCode);
        if (CollectionUtils.isEmpty(marsAuthorityEntities)) {
            return null;
        }
        Collection marsAuthorities = this.nebulaToolkitService.copyCollectionByWhiteList(marsAuthorityEntities, MarsAuthorityEntity.class, MarsAuthority.class, LinkedHashSet.class, ArrayList.class, new String[]{"marsSelectDetails"});
        return Sets.newLinkedHashSet((Iterable)marsAuthorities);
    }

    public Set<MarsAuthority> findByListCodeAndCurrentUser(String listCode) {
        if (StringUtils.isBlank((CharSequence)listCode)) {
            return null;
        }
        LinkedHashSet matchedMarsAuthoritys = Sets.newLinkedHashSet();
        Set<MarsAuthority> marsAuthoritys = this.findDetailsByListCode(listCode);
        if (CollectionUtils.isEmpty(marsAuthoritys)) {
            return null;
        }
        List selectScopeRegisters = this.selectScopeRegisterService.findRegisters();
        if (CollectionUtils.isEmpty((Collection)selectScopeRegisters)) {
            return null;
        }
        block0: for (MarsAuthority marsAuthority : marsAuthoritys) {
            String currentScopeKey = marsAuthority.getScopeKey();
            String[] scopeValues = marsAuthority.getScopeValues();
            if (scopeValues == null || scopeValues.length == 0) continue;
            for (SelectScopeRegisterVo selectScopeRegister : selectScopeRegisters) {
                String scopeKey = selectScopeRegister.getScopeKey();
                if (!StringUtils.equals((CharSequence)currentScopeKey, (CharSequence)scopeKey) || !this.selectScopeRegisterService.matched(currentScopeKey, scopeValues)) continue;
                matchedMarsAuthoritys.add(marsAuthority);
                continue block0;
            }
        }
        return matchedMarsAuthoritys;
    }

    public boolean validate(Class<?> sourceClass, Class<?> targetClass) {
        return sourceClass == MarsAuthorityEntity.class && targetClass == MarsAuthority.class;
    }

    public void callback(Class<MarsAuthorityEntity> sourceClass, List<MarsAuthorityEntity> sourceObjects, Class<MarsAuthority> targetClass, List<MarsAuthority> targetObjects) {
        for (int index = 0; index < sourceObjects.size(); ++index) {
            MarsAuthorityEntity marsAuthorityEntity = sourceObjects.get(index);
            MarsAuthority marsAuthority = targetObjects.get(index);
            String scopeCodes = marsAuthorityEntity.getScopeValues();
            marsAuthority.setScopeValues(StringUtils.split((String)scopeCodes, (char)','));
            Set marsAuthorityDetailEntitys = marsAuthorityEntity.getMarsSelectDetails();
            marsAuthorityDetailEntitys = (Set)ObjectUtils.defaultIfNull(marsAuthorityDetailEntitys, (Object)Sets.newHashSet());
            Map<String, String> marsAuthorityDetailMapping = marsAuthorityDetailEntitys.stream().collect(Collectors.toMap(MarsAuthorityDetailEntity::getSelectModeKey, item -> StringUtils.isBlank((CharSequence)item.getSelectModeValues()) ? "" : item.getSelectModeValues()));
            Set marsAuthorityDetails = marsAuthority.getMarsSelectDetails();
            if (CollectionUtils.isEmpty((Collection)marsAuthorityDetails)) continue;
            for (MarsAuthorityDetail marsAuthorityDetail : marsAuthorityDetails) {
                String selectModeKey = marsAuthorityDetail.getSelectModeKey();
                String selectModeValues = marsAuthorityDetailMapping.get(selectModeKey);
                if (!StringUtils.isNotBlank((CharSequence)selectModeValues)) continue;
                marsAuthorityDetail.setSelectModeValues(StringUtils.split((String)selectModeValues, (char)','));
            }
        }
    }

    private MarsAuthority buildMarsAuthority(String id) {
        List<MarsAuthorityExcludedFieldDetailEntity> fieldDetailEntities;
        MarsAuthorityEntity authorityEntity = this.marsAuthorityRepository.findById(id).orElse(null);
        if (Objects.isNull((Object)authorityEntity)) {
            return null;
        }
        MarsAuthority marsAuthority = (MarsAuthority)this.nebulaToolkitService.copyObjectByWhiteList((Object)authorityEntity, MarsAuthority.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        List<MarsAuthorityDetailEntity> detailEntities = this.marsAuthorityDetailRepository.findByMarsAuthorityId(id);
        if (!CollectionUtils.isEmpty(detailEntities)) {
            Collection authorityDetails = this.nebulaToolkitService.copyCollectionByWhiteList(detailEntities, MarsAuthorityDetailEntity.class, MarsAuthorityDetail.class, LinkedHashSet.class, ArrayList.class, new String[0]);
            marsAuthority.setMarsSelectDetails((Set)Sets.newHashSet((Iterable)authorityDetails));
        }
        if (!CollectionUtils.isEmpty(fieldDetailEntities = this.marsAuthorityExcludedFieldDetailRepository.findByMarsAuthorityId(id))) {
            Collection fieldDetails = this.nebulaToolkitService.copyCollectionByWhiteList(fieldDetailEntities, MarsAuthorityExcludedFieldDetailEntity.class, MarsAuthorityExcludedFieldDetail.class, LinkedHashSet.class, ArrayList.class, new String[0]);
            marsAuthority.setExcludedFieldDetails((Set)Sets.newHashSet((Iterable)fieldDetails));
        }
        return marsAuthority;
    }
}

