/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.nebula.mars.local.service.internal;

import com.bizunited.nebula.mars.sdk.register.SelectAuthorityModeGroupRegister;
import com.bizunited.nebula.mars.sdk.service.SelectAuthorityModeGroupRegisterService;
import com.bizunited.nebula.mars.sdk.vo.SelectAuthorityModeGroupRegisterVo;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Lazy
@Component(value="selectAuthorityModeGroupRegisterService")
public class SelectAuthorityModeGroupRegisterServiceImpl
implements SelectAuthorityModeGroupRegisterService {
    @Autowired(required=false)
    @Lazy
    private List<SelectAuthorityModeGroupRegister> selectAuthorityModeGroupRegisters;

    public SelectAuthorityModeGroupRegisterVo findByGroupCode(String groupCode) {
        if (StringUtils.isBlank((CharSequence)groupCode) || CollectionUtils.isEmpty(this.selectAuthorityModeGroupRegisters)) {
            return null;
        }
        for (SelectAuthorityModeGroupRegister selectAuthorityModeGroupRegister : this.selectAuthorityModeGroupRegisters) {
            String currentGroupCode = selectAuthorityModeGroupRegister.groupCode();
            if (!StringUtils.equals((CharSequence)currentGroupCode, (CharSequence)groupCode)) continue;
            return this.build(selectAuthorityModeGroupRegister);
        }
        return null;
    }

    public List<SelectAuthorityModeGroupRegisterVo> findByGroupCodes(String[] groupCodes) {
        if (groupCodes == null || groupCodes.length == 0) {
            return null;
        }
        ArrayList selectAuthorityModeGroupRegisters = Lists.newArrayList();
        for (String groupCode : groupCodes) {
            SelectAuthorityModeGroupRegisterVo item = this.findByGroupCode(groupCode);
            if (item == null) continue;
            selectAuthorityModeGroupRegisters.add(item);
        }
        return selectAuthorityModeGroupRegisters;
    }

    private SelectAuthorityModeGroupRegisterVo build(SelectAuthorityModeGroupRegister selectAuthorityModeGroupRegister) {
        String groupCode = selectAuthorityModeGroupRegister.groupCode();
        String groupName = selectAuthorityModeGroupRegister.groupName();
        Set viewFieldNames = selectAuthorityModeGroupRegister.viewFieldNames();
        Set repositoryFieldNames = selectAuthorityModeGroupRegister.repositoryFieldNames();
        SelectAuthorityModeGroupRegisterVo selectAuthorityModeGroupRegisterVo = new SelectAuthorityModeGroupRegisterVo();
        selectAuthorityModeGroupRegisterVo.setGroupCode(groupCode);
        selectAuthorityModeGroupRegisterVo.setGroupName(groupName);
        selectAuthorityModeGroupRegisterVo.setRepositoryFieldNames(repositoryFieldNames);
        selectAuthorityModeGroupRegisterVo.setViewFieldNames(viewFieldNames);
        return selectAuthorityModeGroupRegisterVo;
    }

    public List<SelectAuthorityModeGroupRegisterVo> findByViewFieldNames(String[] viewFiledNames, Boolean includeDefault) {
        if (viewFiledNames == null || viewFiledNames.length == 0) {
            return null;
        }
        HashSet sourceViewFiledNames = Sets.newHashSet((Object[])viewFiledNames);
        ArrayList results = Lists.newArrayList();
        for (SelectAuthorityModeGroupRegister selectAuthorityModeGroupRegister : this.selectAuthorityModeGroupRegisters) {
            Set targetViewFieldNames = selectAuthorityModeGroupRegister.viewFieldNames();
            if (CollectionUtils.isEmpty((Collection)targetViewFieldNames) || Sets.intersection((Set)sourceViewFiledNames, (Set)targetViewFieldNames).isEmpty()) continue;
            results.add(this.build(selectAuthorityModeGroupRegister));
        }
        return results;
    }
}

