/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.nebula.mars.local.service.internal;

import com.bizunited.nebula.mars.sdk.register.SelectScopeRegister;
import com.bizunited.nebula.mars.sdk.service.SelectScopeRegisterService;
import com.bizunited.nebula.mars.sdk.vo.SelectScopeRegisterVo;
import com.bizunited.nebula.security.sdk.login.UserIdentity;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Lazy
@Component(value="selectScopeRegisterService")
public class SelectScopeRegisterServiceImpl
implements SelectScopeRegisterService {
    @Autowired(required=false)
    @Lazy
    private List<SelectScopeRegister> selectScopeRegisters;

    public List<SelectScopeRegisterVo> findRegisters() {
        if (CollectionUtils.isEmpty(this.selectScopeRegisters)) {
            return null;
        }
        ArrayList results = Lists.newArrayList();
        for (SelectScopeRegister selectScopeRegister : this.selectScopeRegisters) {
            String controlKey = selectScopeRegister.controlKey();
            String controlName = selectScopeRegister.controlName();
            String scopeKey = selectScopeRegister.scopeKey();
            String selectName = selectScopeRegister.selectName();
            SelectScopeRegisterVo vo = new SelectScopeRegisterVo();
            vo.setControlKey(controlKey);
            vo.setControlName(controlName);
            vo.setScopeKey(scopeKey);
            vo.setSelectName(selectName);
            results.add(vo);
        }
        return results;
    }

    private SelectScopeRegister findRegisterByScopeKey(String scopeKey) {
        if (CollectionUtils.isEmpty(this.selectScopeRegisters) || StringUtils.isBlank((CharSequence)scopeKey)) {
            return null;
        }
        for (SelectScopeRegister selectScopeRegister : this.selectScopeRegisters) {
            String currentScopeKey = selectScopeRegister.scopeKey();
            if (!StringUtils.equals((CharSequence)currentScopeKey, (CharSequence)scopeKey)) continue;
            return selectScopeRegister;
        }
        return null;
    }

    public boolean matched(String scopeKey, String[] scopeValues) {
        if (StringUtils.isBlank((CharSequence)scopeKey) || StringUtils.isAnyBlank((CharSequence[])scopeValues)) {
            return false;
        }
        SelectScopeRegister selectScopeRegister = this.findRegisterByScopeKey(scopeKey);
        if (selectScopeRegister == null) {
            return false;
        }
        SecurityContext securityContext = SecurityContextHolder.getContext();
        Authentication authentication = securityContext.getAuthentication();
        Object authenticationDetails = authentication.getDetails();
        if (authenticationDetails == null || !(authenticationDetails instanceof UserIdentity)) {
            return false;
        }
        UserIdentity loginDetails = (UserIdentity)authenticationDetails;
        return selectScopeRegister.matched(loginDetails, scopeValues);
    }
}

