/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.nebula.mars.local.strategy;

import com.alibaba.druid.sql.SQLUtils;
import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.expr.SQLBinaryOpExpr;
import com.alibaba.druid.sql.ast.expr.SQLBinaryOperator;
import com.alibaba.druid.sql.ast.expr.SQLIdentifierExpr;
import com.alibaba.druid.sql.ast.statement.SQLExprTableSource;
import com.alibaba.druid.sql.ast.statement.SQLJoinTableSource;
import com.alibaba.druid.sql.ast.statement.SQLSelect;
import com.alibaba.druid.sql.ast.statement.SQLSelectQueryBlock;
import com.alibaba.druid.sql.ast.statement.SQLSelectStatement;
import com.alibaba.druid.sql.ast.statement.SQLSubqueryTableSource;
import com.alibaba.druid.sql.ast.statement.SQLTableSource;
import com.bizunited.nebula.common.enums.DatabaseType;
import com.bizunited.nebula.common.repository.interceptor.NebulaRepositoryInterceptorStrategy;
import com.bizunited.nebula.common.repository.interceptor.SqlCommandType;
import com.bizunited.nebula.mars.local.configuration.MarsAuthorityProperties;
import com.bizunited.nebula.mars.sdk.context.MarsAuthorityContext;
import com.bizunited.nebula.mars.sdk.context.MarsAuthorityContextHolder;
import com.bizunited.nebula.mars.sdk.converter.MarsAuthorityAstConverter;
import com.bizunited.nebula.mars.sdk.converter.MarsAuthoritySqlConverter;
import com.bizunited.nebula.mars.sdk.service.MarsAuthorityService;
import com.bizunited.nebula.mars.sdk.service.SelectAuthorityModeGroupRegisterService;
import com.bizunited.nebula.mars.sdk.service.SelectAuthorityModeRegisterService;
import com.bizunited.nebula.mars.sdk.vo.MarsAuthority;
import com.bizunited.nebula.mars.sdk.vo.SelectAuthorityModeGroupRegisterVo;
import com.bizunited.nebula.mars.sdk.vo.SelectAuthorityModeRegisterVo;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Lazy
@Component
public class MarsAuthorityRepositoryInterceptorStrategy
implements NebulaRepositoryInterceptorStrategy {
    private static final Logger LOGGER = LoggerFactory.getLogger(MarsAuthorityRepositoryInterceptorStrategy.class);
    @Autowired
    private MarsAuthorityService marsAuthorityService;
    @Autowired
    private SelectAuthorityModeRegisterService selectAuthorityModeRegisterService;
    @Autowired
    private SelectAuthorityModeGroupRegisterService selectAuthorityModeGroupRegisterService;
    @Autowired(required=false)
    private List<MarsAuthorityAstConverter> marsAuthorityValueAstConverters;
    @Autowired(required=false)
    private List<MarsAuthoritySqlConverter> marsAuthoritySqlConverters;
    @Autowired
    private MarsAuthorityProperties marsAuthorityProperties;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String intercept(SqlCommandType sqlCommandType, String sourceSql, Connection currentConnection) {
        String[] ignoreTableNames;
        if (sqlCommandType != SqlCommandType.SELECT) {
            return sourceSql;
        }
        DatabaseType databaseType = null;
        try {
            String databaseProduectName = currentConnection.getMetaData().getDatabaseProductName();
            String upperDatabaseProductName = databaseProduectName.toUpperCase();
            databaseType = DatabaseType.valueOfByDesc((String)upperDatabaseProductName);
            if (databaseType == null) {
                return sourceSql;
            }
        }
        catch (SQLException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return sourceSql;
        }
        if (CollectionUtils.isEmpty(this.marsAuthorityValueAstConverters)) {
            return sourceSql;
        }
        MarsAuthorityContext marsAuthorityContext = MarsAuthorityContextHolder.getContext();
        String listCode = marsAuthorityContext.getListCode();
        if (StringUtils.isBlank((CharSequence)listCode)) {
            return sourceSql;
        }
        if (marsAuthorityContext.building().booleanValue()) {
            return sourceSql;
        }
        for (String ignoreTableName : ignoreTableNames = this.marsAuthorityProperties.getIgnoreTableNames()) {
            if (StringUtils.indexOfIgnoreCase((CharSequence)sourceSql, (CharSequence)ignoreTableName) == -1) continue;
            return sourceSql;
        }
        boolean isOwner = false;
        try {
            String newSql;
            String[] mergers;
            Object sourceClass;
            Map selectAuthorityModeValueMapping;
            Set marsAuthorityCodes;
            String ignoreTableName;
            if (!marsAuthorityContext.building().booleanValue()) {
                isOwner = true;
                marsAuthorityContext.setBuilding(Boolean.valueOf(isOwner));
            }
            if (CollectionUtils.isEmpty((Collection)(marsAuthorityCodes = marsAuthorityContext.getMatchedMarsAuthorityCodes()))) {
                Set matchedMarsAuthoritys = this.marsAuthorityService.findByListCodeAndCurrentUser(listCode);
                if (CollectionUtils.isEmpty((Collection)matchedMarsAuthoritys)) {
                    ignoreTableName = this.validateNoData(listCode, sourceSql, databaseType);
                    return ignoreTableName;
                }
                marsAuthorityCodes = matchedMarsAuthoritys.stream().filter(item -> item.getStatus() == 1).map(MarsAuthority::getCode).distinct().collect(Collectors.toSet());
            }
            if (CollectionUtils.isEmpty((Map)(selectAuthorityModeValueMapping = this.selectAuthorityModeRegisterService.findByAuthorityCodes(marsAuthorityCodes)))) {
                ignoreTableName = this.validateNoData(listCode, sourceSql, databaseType);
                return ignoreTableName;
            }
            LinkedHashMap mappedMarsAuthorityDetail = Maps.newLinkedHashMap();
            for (Map.Entry selectAuthorityModeValueItem : selectAuthorityModeValueMapping.entrySet()) {
                String[] marsAuthorityCode = (String[])selectAuthorityModeValueItem.getKey();
                Set selectAuthorityModeValues = (Set)selectAuthorityModeValueItem.getValue();
                if (CollectionUtils.isEmpty((Collection)selectAuthorityModeValues)) continue;
                LinkedHashMap mappedSelectModeGroupDetails = Maps.newLinkedHashMap();
                for (SelectAuthorityModeRegisterVo selectAuthorityModeRegisterVo : selectAuthorityModeValues) {
                    MarsAuthorityAstConverter marsAuthorityValueAstConverter;
                    String converterKey = selectAuthorityModeRegisterVo.getConverterKey();
                    boolean isArrayValue = selectAuthorityModeRegisterVo.getArrayValue();
                    Object value = selectAuthorityModeRegisterVo.getModeValue();
                    String selectModeGroupCode = selectAuthorityModeRegisterVo.getGroupCode();
                    sourceClass = null;
                    String string = selectAuthorityModeRegisterVo.getModeValueClass();
                    if (StringUtils.isNotBlank((CharSequence)string)) {
                        try {
                            sourceClass = Class.forName(string);
                        }
                        catch (ClassNotFoundException e) {
                            LOGGER.warn("\u7ecf\u8fc7findByAuthorityCodes\u65b9\u6cd5\uff0c\u4e0d\u4f1a\u51fa\u73b0\u8fd9\u79cd\u60c5\u51b5");
                            continue;
                        }
                    }
                    if ((marsAuthorityValueAstConverter = this.findMarsAuthorityValueAstConverter(converterKey)) == null) continue;
                    Object valueAstResults = null;
                    if (!marsAuthorityValueAstConverter.support((Class)sourceClass, isArrayValue) || (valueAstResults = marsAuthorityValueAstConverter.converter(databaseType, (Class)sourceClass, isArrayValue, value)) == null) continue;
                    Pair pair = Pair.of((Object)selectAuthorityModeRegisterVo, (Object)valueAstResults);
                    mappedSelectModeGroupDetails.put(selectModeGroupCode, pair);
                }
                if (CollectionUtils.isEmpty((Map)mappedSelectModeGroupDetails)) continue;
                mappedMarsAuthorityDetail.put(marsAuthorityCode, mappedSelectModeGroupDetails);
            }
            if (CollectionUtils.isEmpty((Map)mappedMarsAuthorityDetail)) {
                String string = this.validateNoData(listCode, sourceSql, databaseType);
                return string;
            }
            boolean buildWithOr = false;
            if (this.marsAuthorityProperties != null && (mergers = this.marsAuthorityProperties.getMergers()) != null && mergers.length > 0) {
                for (String merger : mergers) {
                    String[] mergerArrays = StringUtils.split((String)merger, (String)",");
                    if (mergerArrays == null || mergerArrays.length != 2 || !StringUtils.equalsIgnoreCase((CharSequence)listCode, (CharSequence)mergerArrays[0]) || !StringUtils.equalsIgnoreCase((CharSequence)"or", (CharSequence)mergerArrays[1])) continue;
                    buildWithOr = true;
                }
            }
            Pair<SQLSelectStatement, MarsAuthoritySqlConverter> pair = this.findSQLSelectStatement(sourceSql, databaseType);
            SQLSelectStatement sqlSelectStatement = (SQLSelectStatement)pair.getLeft();
            MarsAuthoritySqlConverter selectedMarsAuthoritySqlConverter = (MarsAuthoritySqlConverter)pair.getRight();
            if (sqlSelectStatement == null) {
                String mappedSelectModeGroupDetails = this.validateNoData(listCode, sourceSql, databaseType);
                return mappedSelectModeGroupDetails;
            }
            SQLSelect sqlSelect = sqlSelectStatement.getSelect();
            SQLSelectQueryBlock sqlSelectQuery = (SQLSelectQueryBlock)sqlSelect.getQuery();
            SQLSelect topSqlSelect = sqlSelectStatement.getSelect();
            SQLSelectQueryBlock topSqlSelectQuery = (SQLSelectQueryBlock)topSqlSelect.getQuery();
            SQLExpr topWhereExpr = topSqlSelectQuery.getWhere();
            SQLTableSource topSQLTableSource = topSqlSelectQuery.getFrom();
            if (topSQLTableSource != null && topWhereExpr == null && topSQLTableSource instanceof SQLSubqueryTableSource) {
                SQLSubqueryTableSource subqueryTableSource = (SQLSubqueryTableSource)topSQLTableSource;
                sqlSelect = subqueryTableSource.getSelect();
                sqlSelectQuery = (SQLSelectQueryBlock)sqlSelect.getQuery();
            }
            LinkedHashSet allConditions = Sets.newLinkedHashSet();
            for (Map.Entry entry : mappedMarsAuthorityDetail.entrySet()) {
                Map mappedSelectModeGroup = (Map)entry.getValue();
                Object conditions = this.analysisFromSql(currentConnection, databaseType, selectedMarsAuthoritySqlConverter, sqlSelectQuery, mappedSelectModeGroup);
                if (CollectionUtils.isEmpty(conditions)) continue;
                allConditions.add(conditions);
            }
            if (CollectionUtils.isEmpty((Collection)allConditions)) {
                sourceClass = this.validateNoData(listCode, sourceSql, databaseType);
                return sourceClass;
            }
            SQLExpr sqlOldWhere = sqlSelectQuery.getWhere();
            ArrayList arrayList = Lists.newArrayList();
            for (Object conditions : allConditions) {
                SQLExpr newRgihtNode = this.buildWhereTree(0, (List<SQLExpr>)conditions, databaseType.getDesc());
                arrayList.add(newRgihtNode);
            }
            SQLExpr sqlNewWhere = null;
            if (sqlOldWhere != null) {
                if (buildWithOr) {
                    sqlNewWhere = SQLBinaryOpExpr.and((SQLExpr)sqlOldWhere, (SQLExpr)SQLBinaryOpExpr.or((List)arrayList));
                } else {
                    sqlNewWhere = sqlOldWhere;
                    for (SQLExpr newRightNode : arrayList) {
                        sqlNewWhere = SQLBinaryOpExpr.and((SQLExpr)sqlNewWhere, (SQLExpr)newRightNode);
                    }
                }
            } else if (buildWithOr) {
                sqlNewWhere = SQLBinaryOpExpr.or((List)arrayList);
            } else {
                sqlNewWhere = (SQLExpr)arrayList.get(0);
                for (int index = 1; index < arrayList.size(); ++index) {
                    sqlNewWhere = SQLBinaryOpExpr.and((SQLExpr)sqlNewWhere, (SQLExpr)((SQLExpr)arrayList.get(index)));
                }
            }
            sqlSelectQuery.setWhere(sqlNewWhere);
            String string = newSql = sqlSelectStatement.toString();
            return string;
        }
        finally {
            if (isOwner) {
                marsAuthorityContext.setBuilding(Boolean.valueOf(false));
            }
        }
    }

    private String validateNoData(String listCode, String sourceSql, DatabaseType databaseType) {
        CharSequence[] nodatas;
        if (this.marsAuthorityProperties != null && StringUtils.equalsAnyIgnoreCase((CharSequence)listCode, (CharSequence[])(nodatas = this.marsAuthorityProperties.getNodata()))) {
            Pair<SQLSelectStatement, MarsAuthoritySqlConverter> pair = this.findSQLSelectStatement(sourceSql, databaseType);
            SQLSelectStatement sqlSelectStatement = (SQLSelectStatement)pair.getLeft();
            if (sqlSelectStatement == null) {
                return sourceSql;
            }
            SQLSelect sqlSelect = sqlSelectStatement.getSelect();
            SQLSelectQueryBlock sqlSelectQuery = (SQLSelectQueryBlock)sqlSelect.getQuery();
            SQLExpr falseExpr = SQLUtils.toSQLExpr((String)"FALSE");
            SQLExpr oldWhere = sqlSelectQuery.getWhere();
            if (oldWhere != null) {
                sqlSelectQuery.setWhere(SQLBinaryOpExpr.and((SQLExpr)oldWhere, (SQLExpr)falseExpr));
            } else {
                sqlSelectQuery.setWhere(falseExpr);
            }
            return sqlSelectStatement.toString();
        }
        return sourceSql;
    }

    private Pair<SQLSelectStatement, MarsAuthoritySqlConverter> findSQLSelectStatement(String sourceSql, DatabaseType databaseType) {
        MarsAuthoritySqlConverter selectedMarsAuthoritySqlConverter = null;
        SQLSelectStatement sqlSelectStatement = null;
        for (MarsAuthoritySqlConverter marsAuthoritySqlConverter : this.marsAuthoritySqlConverters) {
            if (!marsAuthoritySqlConverter.support(databaseType)) continue;
            selectedMarsAuthoritySqlConverter = marsAuthoritySqlConverter;
            sqlSelectStatement = (SQLSelectStatement)marsAuthoritySqlConverter.converter(sourceSql, databaseType);
            break;
        }
        return Pair.of(sqlSelectStatement, selectedMarsAuthoritySqlConverter);
    }

    private void analysisSQL(Connection connection, DatabaseType databaseType, MarsAuthoritySqlConverter marsAuthoritySqlConverter, SQLTableSource fromSQLTableSource, Set<DatabaseTableNode> tableNodes, Map<String, Pair<SelectAuthorityModeRegisterVo, Object>> mappedSelectModeGroup) {
        if (fromSQLTableSource instanceof SQLExprTableSource) {
            SQLExprTableSource sqlExprTableSource = (SQLExprTableSource)fromSQLTableSource;
            DatabaseTableNode databaseTableNode = this.buildTableNode(sqlExprTableSource);
            if (databaseTableNode != null) {
                tableNodes.add(databaseTableNode);
            }
        } else if (fromSQLTableSource instanceof SQLSubqueryTableSource) {
            SQLSubqueryTableSource subqueryTableSource = (SQLSubqueryTableSource)fromSQLTableSource;
            SQLSelect sqlSelect = subqueryTableSource.getSelect();
            SQLSelectQueryBlock subSqlSelectQuery = (SQLSelectQueryBlock)sqlSelect.getQuery();
            this.analysisFromSql(connection, databaseType, marsAuthoritySqlConverter, subSqlSelectQuery, mappedSelectModeGroup);
        } else if (fromSQLTableSource instanceof SQLJoinTableSource) {
            SQLJoinTableSource sqlJoinTableSource = (SQLJoinTableSource)fromSQLTableSource;
            SQLTableSource leftSQLTableSource = sqlJoinTableSource.getLeft();
            this.analysisSQL(connection, databaseType, marsAuthoritySqlConverter, leftSQLTableSource, tableNodes, mappedSelectModeGroup);
            SQLTableSource rightSQLTableSource = sqlJoinTableSource.getRight();
            this.analysisSQL(connection, databaseType, marsAuthoritySqlConverter, rightSQLTableSource, tableNodes, mappedSelectModeGroup);
        }
    }

    private List<SQLExpr> analysisFromSql(Connection connection, DatabaseType databaseType, MarsAuthoritySqlConverter marsAuthoritySqlConverter, SQLSelectQueryBlock sqlSelectQuery, Map<String, Pair<SelectAuthorityModeRegisterVo, Object>> mappedSelectModeGroup) {
        LinkedHashSet tableNodes = Sets.newLinkedHashSet();
        SQLTableSource fromSQLTableSource = sqlSelectQuery.getFrom();
        this.analysisSQL(connection, databaseType, marsAuthoritySqlConverter, fromSQLTableSource, tableNodes, mappedSelectModeGroup);
        if (CollectionUtils.isEmpty((Collection)tableNodes)) {
            return null;
        }
        LinkedHashMap requestMatchedFields = Maps.newLinkedHashMap();
        for (Map.Entry<String, Pair<SelectAuthorityModeRegisterVo, Object>> mappedSelectModeGroupItem : mappedSelectModeGroup.entrySet()) {
            Object repositoryFieldNames;
            String selectModGroupKey = mappedSelectModeGroupItem.getKey();
            SelectAuthorityModeGroupRegisterVo selectAuthorityModeGroupRegisterVo = this.selectAuthorityModeGroupRegisterService.findByGroupCode(selectModGroupKey);
            if (selectAuthorityModeGroupRegisterVo == null || CollectionUtils.isEmpty((Collection)(repositoryFieldNames = selectAuthorityModeGroupRegisterVo.getRepositoryFieldNames()))) continue;
            requestMatchedFields.put(selectModGroupKey, repositoryFieldNames);
        }
        if (CollectionUtils.isEmpty((Map)requestMatchedFields)) {
            return null;
        }
        LinkedHashMap matchedTablesDimensionMapping = Maps.newLinkedHashMap();
        for (DatabaseTableNode databaseTableNode : tableNodes) {
            Map matchedDimensionMapping = marsAuthoritySqlConverter.analysisTableFileds(connection, databaseTableNode.tableName, (Map)requestMatchedFields);
            if (CollectionUtils.isEmpty((Map)matchedDimensionMapping)) continue;
            for (String selectModGroupKey : matchedDimensionMapping.keySet()) {
                requestMatchedFields.remove(selectModGroupKey);
            }
            matchedTablesDimensionMapping.put(databaseTableNode, matchedDimensionMapping);
        }
        if (CollectionUtils.isEmpty((Map)matchedTablesDimensionMapping)) {
            return null;
        }
        ArrayList marsAuthorityConditions = Lists.newArrayList();
        for (Map.Entry matchedTablesDimensionItem : matchedTablesDimensionMapping.entrySet()) {
            DatabaseTableNode databaseTableNode = (DatabaseTableNode)matchedTablesDimensionItem.getKey();
            String alias = databaseTableNode.alias;
            String tableName = databaseTableNode.tableName;
            Map matchedDimensionMapping = (Map)matchedTablesDimensionItem.getValue();
            for (Map.Entry matchedDimensionMappingItem : matchedDimensionMapping.entrySet()) {
                String selectModeGroupCode = (String)matchedDimensionMappingItem.getKey();
                String fieldName = (String)matchedDimensionMappingItem.getValue();
                Pair<SelectAuthorityModeRegisterVo, Object> marsAuthorityDetailPair = mappedSelectModeGroup.get(selectModeGroupCode);
                SelectAuthorityModeRegisterVo selectAuthorityModeRegisterVo = (SelectAuthorityModeRegisterVo)marsAuthorityDetailPair.getLeft();
                String converterKey = selectAuthorityModeRegisterVo.getConverterKey();
                MarsAuthorityAstConverter marsAuthorityValueAstConverter = this.findMarsAuthorityValueAstConverter(converterKey);
                Object astValue = marsAuthorityDetailPair.getRight();
                if (astValue == null) continue;
                SQLExpr sqlExpr = marsAuthorityValueAstConverter.op(tableName, alias, fieldName, astValue);
                marsAuthorityConditions.add(sqlExpr);
            }
        }
        return marsAuthorityConditions;
    }

    private MarsAuthorityAstConverter findMarsAuthorityValueAstConverter(String converterKey) {
        if (CollectionUtils.isEmpty(this.marsAuthorityValueAstConverters)) {
            return null;
        }
        for (MarsAuthorityAstConverter marsAuthorityValueAstConverter : this.marsAuthorityValueAstConverters) {
            String currentConverterKey = marsAuthorityValueAstConverter.converterKey();
            if (!StringUtils.equals((CharSequence)currentConverterKey, (CharSequence)converterKey)) continue;
            return marsAuthorityValueAstConverter;
        }
        return null;
    }

    private SQLExpr buildWhereTree(int index, List<SQLExpr> marsAuthorityConditions, String dbType) {
        SQLExpr marsAuthorityCondition = marsAuthorityConditions.get(index);
        if (index + 1 == marsAuthorityConditions.size()) {
            return marsAuthorityCondition;
        }
        SQLBinaryOpExpr rootNode = new SQLBinaryOpExpr(dbType);
        rootNode.setRight(marsAuthorityCondition);
        rootNode.setOperator(SQLBinaryOperator.BooleanAnd);
        int currentIndex = index;
        if (currentIndex + 2 < marsAuthorityConditions.size()) {
            rootNode.setLeft(this.buildWhereTree(currentIndex + 1, marsAuthorityConditions, dbType));
        } else if (currentIndex + 2 == marsAuthorityConditions.size()) {
            SQLExpr lastMarsAuthorityCondition = marsAuthorityConditions.get(currentIndex + 1);
            rootNode.setLeft(lastMarsAuthorityCondition);
        }
        return rootNode;
    }

    private DatabaseTableNode buildTableNode(SQLExprTableSource sqlTableSource) {
        String alias = sqlTableSource.getAlias();
        SQLExpr sqlExpr = sqlTableSource.getExpr();
        if (sqlExpr instanceof SQLIdentifierExpr) {
            SQLIdentifierExpr sqlIdentifierExpr = (SQLIdentifierExpr)sqlExpr;
            String tableName = sqlIdentifierExpr.getName();
            DatabaseTableNode databaseTableNode = new DatabaseTableNode(alias, tableName);
            return databaseTableNode;
        }
        return null;
    }

    public int sort() {
        return 0;
    }

    private static class DatabaseTableNode {
        private String alias;
        private String tableName;

        public DatabaseTableNode(String alias, String tableName) {
            this.alias = alias;
            this.tableName = tableName;
        }
    }
}

