package com.bizunited.nebula.mars.sdk.context;

import java.util.Set;

import com.bizunited.nebula.mars.sdk.vo.MarsAuthority;

/**
 * nebula 数据权限 mars 上下文</p>
 * @author yinwenjie
 */
public interface MarsAuthorityContext {
  /**
   * 该参数表示目前mars正在基于某一条语句构建数据权限，这个参数主要是为了避免构造数据权限时出现的循环执行问题</p>
   * 使用该解决办法的前提条件是，数据权限的构造都是在单个线程中完成的
   * @return
   */
  public Boolean building();
  /**
   * 该方法可以设定上下文中的building参数
   * @param building
   */
  public void setBuilding(Boolean building);
  /**
   * 获取一定存在的listCode信息
   * @return
   */
  public String getListCode();
  /**
   * 一定要设定listCode信息，否则本线程不会进行数据权限的处理
   * @param listCode
   */
  public void setListCode(String listCode);
  /**
   * 获取本次SQL拦截执行，基于的已匹配的数据权限设定信息
   * @return
   */
  public Set<String> getMatchedMarsAuthorityCodes();
  /**
   * 设定已经匹配的数据权限设定信息
   * @param marsAuthorityCodes
   */
  public void setMatchedMarsAuthorityCodes(Set<String> marsAuthorityCodes);
  
  /**
   * 设定当前匹配的，本次数据权限处理过程涉及的选定的数据权限信息和关联的明细信息
   * @param matchedMarsAuthoritys
   */
  public void setMatchedMarsAuthoritys(Set<MarsAuthority> matchedMarsAuthoritys);
  
  /**
   * 获取当前匹配的，本次数据权限处理过程涉及的选定的数据权限信息和关联的明细信息
   * @return
   */
  public Set<MarsAuthority> getMatchedMarsAuthoritys();
}
