package com.bizunited.nebula.mars.sdk.converter;

import com.alibaba.fastjson.JSONArray;
import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.List;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.springframework.stereotype.Component;

/**
 * @author ning.zhang
 * @description 该方法服务于字符/字符串数组（包括）判定条件构造，构造后的结构为：terms
 * @date 2024/9/10
*/
@Component
public class ChartArrayMarsElasticsearchAuthorityAstConverter implements MarsElasticsearchAuthorityAstConverter {

  /**
   * 该转换器对应的转换器标识
   */
  public static final String CONVERTER_KEY = "chartArrayMarsAuthorityAstConverter";
  
  @Override
  public String converterKey() {
    return CONVERTER_KEY;
  }
  
  /**
   * 只要是数组，且只要是可串行化的字符类型都支持，例如String、Stringbuffer、StringBuild等等
   */
  @Override
  public boolean support(Class<?> sourceClass, boolean isArrayValue) {
    if(!isArrayValue) {
      return false;
    }
    if(!CharSequence.class.isAssignableFrom(sourceClass)) {
      return false;
    }
    return true;
  }

  @Override
  public Object converter(Class<?> sourceClass, boolean isArrayValue, Object sourceValue) {
    // 注意，由于HTTP请求的原因，这里可能是一个JSONArray
    String[] sourceValues = null;
    if(sourceValue instanceof JSONArray) {
      sourceValues = ((JSONArray)sourceValue).toArray(new String[] {});
    } else {
      Object[] sourceValueObjects = (Object[])sourceValue;
      sourceValues = Arrays.stream(sourceValueObjects).map(Object::toString).toArray(String[]::new);
    }
    return Lists.newArrayList(sourceValues);
  }

  @SuppressWarnings("unchecked")
  @Override
  public QueryBuilder op(String fieldName , Object fieldValue) {
    // 使用terms进行构造
    return QueryBuilders.termsQuery(fieldName, (List<String>) fieldValue);
  }
}
