package com.bizunited.nebula.mars.sdk.converter;

import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.springframework.stereotype.Component;


/**
 * @author ning.zhang
 * @description 该方法服务于最普遍使用的字符/字符串相等的判定条件构造，构造后的结构为：term
 * @date 2024/9/10
*/
@Component
public class ChartEqualMarsElasticsearchAuthorityAstConverter implements MarsElasticsearchAuthorityAstConverter {

  /**
   * 该转换器对应的转换器标识
   */
  public static final String CONVERTER_KEY = "chartEqualMarsAuthorityValueAstConverter";
  
  @Override
  public String converterKey() {
    return CONVERTER_KEY;
  }
  
  /**
   * 不支持数组，但只要是可串行化的字符类型都支持，例如String、Stringbuffer、StringBuild等等
   */
  @Override
  public boolean support(Class<?> sourceClass, boolean isArrayValue) {
    if(isArrayValue) {
      return false;
    }
    if(!CharSequence.class.isAssignableFrom(sourceClass)) {
      return false;
    }
    return true;
  }

  @Override
  public Object converter(Class<?> sourceClass, boolean isArrayValue, Object sourceValue) {
    return sourceValue.toString();
  }

  @Override
  public QueryBuilder op(String fieldName , Object fieldValue) {
    // 使用term进行构造
    return QueryBuilders.termsQuery(fieldName, fieldValue);
  }
}
