package com.bizunited.nebula.mars.sdk.converter;

import java.sql.Connection;
import java.util.Map;
import java.util.Set;

import com.alibaba.druid.sql.ast.SQLStatement;
import com.bizunited.nebula.common.enums.DatabaseType;

/**
 * 转换SQL，以特定数据库的方式，转成支持的AST-SQL结构会话</p>
 * 目前支持的MySQL和Oracle两种数据库
 * @author yinwenjie
 */
public interface MarsAuthoritySqlConverter {
  /**
   * @param dbType
   * @return 如果该转换器不支持指定的数据库类型，返回true；其它情况返回false
   */
  boolean support(DatabaseType databaseType);
  
  /**
   * 如果该实现的support返回的不是null，则该方法将被触发。当前的sql语句要求按照指定数据库进行AS-结构会话的构建
   * @param databaseType
   * @return
   */
  SQLStatement converter(String sql , DatabaseType databaseType);
  
  /**
   * 这是SQL转换分析器中另一个重要方法，该方法将分析在指定数据库的指定数据表中，是否匹配requestMatchedFields中要求匹配的任意一个分组的字段要求
   * @param connection
   * @param tableName 特定的数据表名
   * @param requestMatchedFields 要求进行匹配的字段信息 Key：数据权限的判定维度分组（既是groupCode），Value：在这个维度下，数据表可能设定的字段名（不区分大小写，且按照优先级顺序，只需要匹配一个即可）
   * @return 如果匹配，则返回每一个分组code（返回值的Key信息），所匹配的数据库字段名信息。如果没有任何匹配，或者其它异常情况，返回null
   */
  Map<String , String> analysisTableFileds(Connection connection , String tableName , Map<String , Set<String>> requestMatchedFields);
}
