package com.bizunited.nebula.mars.sdk.converter;

import org.elasticsearch.index.query.QueryBuilder;

/**
 * @author ning.zhang
 * @description 非常重要的接口，负责完成特定数值类型向ES查询的装换
 * @date 2024/9/6
*/
public interface MarsElasticsearchAuthorityAstConverter {
  /**
   * 转换器唯一的key值
   * @return 转换器唯一的key值
   */
  String converterKey();
  /**
   * 转换器是否支持数据类型
   * @param sourceClass 注意，根据不同的SelectAuthorityModeRegister实现，如果SelectAuthorityModeRegister的dynamicValue方法或者staticValue返回为null</br>
   * 那么这里的sourceClass入参是可能为null的
   * @param isArrayValue 是否是数组
   * @return 是否支持
   */
  boolean support(Class<?> sourceClass , boolean isArrayValue);
  /**
   * 该方法可以将本转换接口所支持的值类型，转换成具体的ES查询数据
   * @param sourceClass 注意，根据不同的SelectAuthorityModeRegister实现，如果SelectAuthorityModeRegister的dynamicValue方法或者staticValue返回为null</br>
   * 那么这里的sourceClass入参和sourceValue入参是可能为null的
   * @param isArrayValue 该值是否是一个数组
   * @param sourceValue 将要进行转换的原始值 
   * @return 注意，返回的节点类型可以是任意的druid解析后的AST-Node（或者AST-NODE的集合）。
   */
  Object converter(Class<?> sourceClass , boolean isArrayValue , Object sourceValue);
  /**
   * 条件拼装
   * @param fieldName 字段名
   * @param fieldValue 字段值
   * @return ES查询条件
   */
  QueryBuilder op(String fieldName , Object fieldValue);
}
