package com.bizunited.nebula.mars.sdk.converter;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLSyntaxErrorException;
import java.sql.Statement;

import java.util.Set;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

import com.alibaba.druid.sql.ast.SQLStatement;
import com.alibaba.druid.util.JdbcConstants;
import com.bizunited.nebula.common.enums.DatabaseType;
import com.bizunited.nebula.mars.sdk.utils.MarsMybatisSqlUtils;
import com.google.common.collect.Sets;

/**
 * MySQL数据库下的SQL解析
 * @author yinwenjie
 */
@Component 
public class MySQLMarsAuthoritySqlConverter extends AbstractMarsAuthoritySqlConverter {

  /**
   * 日志
   */
  private static final Logger LOGGER = LoggerFactory.getLogger(MySQLMarsAuthoritySqlConverter.class);
  
  @Override
  public boolean support(DatabaseType databaseType) {
    if(databaseType == DatabaseType.MYSQL) {
      return true;
    }
    return false;
  }

  @Override
  public SQLStatement converter(String sql, DatabaseType databaseType) {
    try {
      return MarsMybatisSqlUtils.parser(sql, JdbcConstants.MYSQL);
    } catch (SQLSyntaxErrorException e) {
      LOGGER.error(e.getMessage() , e);
    }
    return null;
  }
  
  @Override
  protected RepositoryTableNode findRepositoryTableNode(Connection connection , String tableName) {
    String tableFieldSql = "show columns from " + tableName;
    // 开始进行字段匹配
    boolean isExist = false;
    Set<String> fieldNames = Sets.newLinkedHashSet();
    try (Statement statement = connection.createStatement();
        ResultSet resultSet = statement.executeQuery(tableFieldSql);) {
      while (resultSet.next()) {
        isExist = true;
        String filedName = resultSet.getString("Field");
        fieldNames.add(filedName);
      }
    } catch(SQLException e) {
      // TODO 如果抛出异常，最有可能的情况就是没有这个数据表，那么就忽略这个数据表
      LOGGER.warn("没有在数据库中找到指定数据表（{}）的结构信息，最可能的情况是这是一个视图或者结构存在问题，或者所使用的数据库连接账户没有对应的查询权限" , tableName);
    }
    
    if(!isExist) {
      return null;
    }
    
    RepositoryTableNode repositoryTableNode = new RepositoryTableNode(tableName, fieldNames);
    return repositoryTableNode;
  }
}
