package com.bizunited.nebula.mars.sdk.converter;

import java.sql.Connection;
import java.sql.SQLSyntaxErrorException;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

import com.alibaba.druid.sql.ast.SQLStatement;
import com.alibaba.druid.util.JdbcConstants;
import com.bizunited.nebula.common.enums.DatabaseType;
import com.bizunited.nebula.mars.sdk.utils.MarsMybatisSqlUtils;
/**
 * ORACLE数据库下的SQL解析
 * @author yinwenjie
 */
@Component
public class OracleMarsAuthoritySqlConverter extends AbstractMarsAuthoritySqlConverter {

  /**
   * 日志
   */
  private static final Logger LOGGER = LoggerFactory.getLogger(OracleMarsAuthoritySqlConverter.class);
  
  @Override
  public boolean support(DatabaseType databaseType) {
    if(databaseType == DatabaseType.ORACLE) {
      return true;
    }
    return false;
  }

  @Override
  public SQLStatement converter(String sql, DatabaseType databaseType) {
    try {
      return MarsMybatisSqlUtils.parser(sql, JdbcConstants.ORACLE);
    } catch (SQLSyntaxErrorException e) {
      LOGGER.error(e.getMessage() , e);
    }
    return null;
  }

  @Override
  protected RepositoryTableNode findRepositoryTableNode(Connection connection, String tableName) {
    // TODO 目前暂不支持oracle数据库
    LOGGER.warn("目前版本暂不支持oracle的字段匹配，该次数据权限匹配操作被忽略");
    return null;
  }
}
